/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import org.apache.camel.Attachment;
import org.apache.camel.impl.DefaultAttachment;

public class AttachmentMap
extends AbstractMap<String, DataHandler> {
    private Map<String, Attachment> map;

    public AttachmentMap(Map<String, Attachment> backingMap) {
        this.map = backingMap;
    }

    @Override
    public DataHandler put(String key, DataHandler value) {
        Attachment old = this.map.put(key, new DefaultAttachment(value));
        if (old == null) {
            return null;
        }
        return old.getDataHandler();
    }

    @Override
    public Set<Map.Entry<String, DataHandler>> entrySet() {
        return new AttachmentEntrySet(this.map.entrySet());
    }

    public Map<String, Attachment> getOriginalMap() {
        return this.map;
    }

    private static class AttachmentEntry
    implements Map.Entry<String, DataHandler> {
        private Map.Entry<String, Attachment> entry;

        AttachmentEntry(Map.Entry<String, Attachment> backingEntry) {
            this.entry = backingEntry;
        }

        @Override
        public String getKey() {
            return this.entry.getKey();
        }

        @Override
        public DataHandler getValue() {
            Attachment value = this.entry.getValue();
            if (value != null) {
                return value.getDataHandler();
            }
            return null;
        }

        @Override
        public DataHandler setValue(DataHandler value) {
            Attachment oldValue = this.entry.setValue(new DefaultAttachment(value));
            if (oldValue != null) {
                return oldValue.getDataHandler();
            }
            return null;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof AttachmentEntry && this.entry.equals(((AttachmentEntry)o).entry);
        }

        @Override
        public int hashCode() {
            return this.entry.hashCode();
        }
    }

    private static class AttachmentEntrySetIterator
    implements Iterator<Map.Entry<String, DataHandler>> {
        private Iterator<Map.Entry<String, Attachment>> iter;

        AttachmentEntrySetIterator(Iterator<Map.Entry<String, Attachment>> origIterator) {
            this.iter = origIterator;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Map.Entry<String, DataHandler> next() {
            return new AttachmentEntry(this.iter.next());
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }

    private static class AttachmentEntrySet
    extends AbstractSet<Map.Entry<String, DataHandler>> {
        private Set<Map.Entry<String, Attachment>> set;

        AttachmentEntrySet(Set<Map.Entry<String, Attachment>> set) {
            this.set = set;
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public Iterator<Map.Entry<String, DataHandler>> iterator() {
            return new AttachmentEntrySetIterator(this.set.iterator());
        }
    }
}

