/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.persistence.spi;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.apache.unomi.api.CustomItem;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.Persona;
import org.apache.unomi.api.Session;
import org.apache.unomi.api.actions.ActionType;
import org.apache.unomi.api.campaigns.Campaign;
import org.apache.unomi.api.campaigns.events.CampaignEvent;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.conditions.ConditionType;
import org.apache.unomi.api.goals.Goal;
import org.apache.unomi.api.rules.Rule;
import org.apache.unomi.api.segments.Scoring;
import org.apache.unomi.api.segments.Segment;
import org.apache.unomi.persistence.spi.ItemDeserializer;
import org.apache.unomi.persistence.spi.PropertyTypedObjectDeserializer;

public class CustomObjectMapper
extends ObjectMapper {
    private static final long serialVersionUID = 4578277612897061535L;

    public CustomObjectMapper() {
        super.registerModule((Module)new JaxbAnnotationModule());
        this.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        ISO8601DateFormat dateFormat = new ISO8601DateFormat();
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.setDateFormat((DateFormat)dateFormat);
        SimpleModule deserializerModule = new SimpleModule("PropertyTypedObjectDeserializerModule", new Version(1, 0, 0, null, "org.apache.unomi.rest", "deserializer"));
        PropertyTypedObjectDeserializer propertyTypedObjectDeserializer = new PropertyTypedObjectDeserializer();
        propertyTypedObjectDeserializer.registerMapping("type=.*Condition", Condition.class);
        deserializerModule.addDeserializer(Object.class, (JsonDeserializer)propertyTypedObjectDeserializer);
        ItemDeserializer itemDeserializer = new ItemDeserializer();
        deserializerModule.addDeserializer(Item.class, (JsonDeserializer)itemDeserializer);
        HashMap<String, Class<ActionType>> classes = new HashMap<String, Class<ActionType>>();
        classes.put("campaign", Campaign.class);
        classes.put("campaignevent", CampaignEvent.class);
        classes.put("event", Event.class);
        classes.put("goal", Goal.class);
        classes.put("persona", Persona.class);
        classes.put("rule", Rule.class);
        classes.put("scoring", Scoring.class);
        classes.put("segment", Segment.class);
        classes.put("session", Session.class);
        classes.put("conditionType", ConditionType.class);
        classes.put("actionType", ActionType.class);
        for (Map.Entry entry : classes.entrySet()) {
            propertyTypedObjectDeserializer.registerMapping("itemType=" + (String)entry.getKey(), (Class)entry.getValue());
            itemDeserializer.registerMapping((String)entry.getKey(), (Class)entry.getValue());
        }
        propertyTypedObjectDeserializer.registerMapping("itemType=.*", CustomItem.class);
        super.registerModule((Module)deserializerModule);
    }

    public static ObjectMapper getObjectMapper() {
        return Holder.INSTANCE;
    }

    private static class Holder {
        static final CustomObjectMapper INSTANCE = new CustomObjectMapper();

        private Holder() {
        }
    }
}

