/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.io.IoServiceFactoryFactory;
import org.apache.sshd.common.io.mina.MinaServiceFactoryFactory;
import org.apache.sshd.common.io.nio2.Nio2ServiceFactoryFactory;

public enum BuiltinIoServiceFactoryFactories implements NamedFactory<IoServiceFactoryFactory>
{
    NIO2(Nio2ServiceFactoryFactory.class),
    NMINA(MinaServiceFactoryFactory.class);

    public static final Set<BuiltinIoServiceFactoryFactories> VALUES;
    private final Class<? extends IoServiceFactoryFactory> factoryClass;

    private BuiltinIoServiceFactoryFactories(Class<? extends IoServiceFactoryFactory> clazz) {
        this.factoryClass = clazz;
    }

    public final Class<? extends IoServiceFactoryFactory> getFactoryClass() {
        return this.factoryClass;
    }

    @Override
    public final String getName() {
        return this.name().toLowerCase();
    }

    @Override
    public final IoServiceFactoryFactory create() {
        Class<? extends IoServiceFactoryFactory> clazz = this.getFactoryClass();
        try {
            return clazz.newInstance();
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public static BuiltinIoServiceFactoryFactories fromFactoryName(String name) {
        return NamedResource.findByName(name, String.CASE_INSENSITIVE_ORDER, VALUES);
    }

    public static BuiltinIoServiceFactoryFactories fromFactoryClass(Class<?> clazz) {
        if (clazz == null || !IoServiceFactoryFactory.class.isAssignableFrom(clazz)) {
            return null;
        }
        for (BuiltinIoServiceFactoryFactories f : VALUES) {
            if (!clazz.isAssignableFrom(f.getFactoryClass())) continue;
            return f;
        }
        return null;
    }

    static {
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(BuiltinIoServiceFactoryFactories.class));
    }
}

