/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.keyprovider;

import java.security.KeyPair;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.sshd.common.cipher.ECCurves;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public interface KeyPairProvider
extends KeyIdentityProvider {
    public static final String SSH_RSA = "ssh-rsa";
    public static final String SSH_DSS = "ssh-dss";
    public static final String SSH_ED25519 = "ssh-ed25519";
    public static final String ECDSA_SHA2_NISTP256 = ECCurves.nistp256.getKeyType();
    public static final String ECDSA_SHA2_NISTP384 = ECCurves.nistp384.getKeyType();
    public static final String ECDSA_SHA2_NISTP521 = ECCurves.nistp521.getKeyType();
    public static final KeyPairProvider EMPTY_KEYPAIR_PROVIDER = new KeyPairProvider(){

        @Override
        public KeyPair loadKey(String type) {
            return null;
        }

        @Override
        public Iterable<String> getKeyTypes() {
            return Collections.emptyList();
        }

        @Override
        public Iterable<KeyPair> loadKeys() {
            return Collections.emptyList();
        }

        public String toString() {
            return "EMPTY_KEYPAIR_PROVIDER";
        }
    };

    default public KeyPair loadKey(String type) {
        ValidateUtils.checkNotNullAndNotEmpty(type, "No key type to load");
        return GenericUtils.stream(this.loadKeys()).filter(key -> type.equals(KeyUtils.getKeyType(key))).findFirst().orElse(null);
    }

    default public Iterable<String> getKeyTypes() {
        return GenericUtils.stream(this.loadKeys()).map(KeyUtils::getKeyType).filter(GenericUtils::isNotEmpty).collect(Collectors.toSet());
    }

    public static KeyPairProvider wrap(KeyPair ... pairs) {
        return GenericUtils.isEmpty(pairs) ? EMPTY_KEYPAIR_PROVIDER : KeyPairProvider.wrap(Arrays.asList(pairs));
    }

    public static KeyPairProvider wrap(final Iterable<KeyPair> pairs) {
        return pairs == null ? EMPTY_KEYPAIR_PROVIDER : new KeyPairProvider(){

            @Override
            public Iterable<KeyPair> loadKeys() {
                return pairs;
            }

            @Override
            public KeyPair loadKey(String type) {
                for (KeyPair kp : pairs) {
                    String t = KeyUtils.getKeyType(kp);
                    if (!Objects.equals(type, t)) continue;
                    return kp;
                }
                return null;
            }

            @Override
            public Iterable<String> getKeyTypes() {
                LinkedHashSet<String> types = new LinkedHashSet<String>();
                for (KeyPair kp : pairs) {
                    String t = KeyUtils.getKeyType(kp);
                    if (!GenericUtils.isEmpty(t) && types.add(t)) continue;
                }
                return types;
            }
        };
    }
}

