/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.core.control;

import java.util.Dictionary;
import org.apache.aries.proxy.ProxyManager;
import org.apache.karaf.cellar.core.command.CommandHandler;
import org.apache.karaf.cellar.core.control.BasicSwitch;
import org.apache.karaf.cellar.core.control.ManageHandlersCommand;
import org.apache.karaf.cellar.core.control.ManageHandlersResult;
import org.apache.karaf.cellar.core.control.Switch;
import org.apache.karaf.cellar.core.control.SwitchStatus;
import org.apache.karaf.cellar.core.event.EventHandler;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageHandlersCommandHandler
extends CommandHandler<ManageHandlersCommand, ManageHandlersResult> {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(ManageHandlersCommandHandler.class);
    public static final String SWITCH_ID = "org.apache.karaf.cellar.command.listhandlers.switch";
    private final Switch commandSwitch = new BasicSwitch("org.apache.karaf.cellar.command.listhandlers.switch");
    private ProxyManager proxyManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ManageHandlersResult execute(ManageHandlersCommand command) {
        ManageHandlersResult result;
        block12: {
            result = new ManageHandlersResult(command.getId());
            BundleContext bundleContext = ((BundleReference)this.getClass().getClassLoader()).getBundle().getBundleContext();
            ServiceReference[] references = new ServiceReference[]{};
            try {
                references = bundleContext.getServiceReferences(EventHandler.class.getName(), "(managed=true)");
                if (references == null || references.length <= 0) break block12;
                for (ServiceReference ref : references) {
                    EventHandler handler = (EventHandler)bundleContext.getService(ref);
                    if (this.proxyManager.isProxy((Object)handler)) {
                        handler = (EventHandler)this.proxyManager.unwrap((Object)handler).call();
                    }
                    if (command.getHandlerName() == null) {
                        result.getHandlers().put(handler.getClass().getName(), handler.getSwitch().getStatus().name());
                        continue;
                    }
                    if (!command.getHandlerName().equals(handler.getClass().getName())) continue;
                    if (command.getStatus() != null) {
                        if (command.getStatus().booleanValue()) {
                            this.persist(handler.getClass().getName(), SwitchStatus.ON);
                            handler.getSwitch().turnOn();
                        } else {
                            this.persist(handler.getClass().getName(), SwitchStatus.OFF);
                            handler.getSwitch().turnOff();
                        }
                    }
                    result.getHandlers().put(handler.getClass().getName(), handler.getSwitch().getStatus().name());
                    break;
                }
            }
            catch (Exception e) {
                LOGGER.error("Can't get the current handlers status", (Throwable)e);
            }
            finally {
                if (references == null) break block12;
                for (ServiceReference ref : references) {
                    bundleContext.ungetService(ref);
                }
            }
        }
        return result;
    }

    private void persist(String handler, SwitchStatus switchStatus) {
        try {
            Dictionary properties;
            Configuration configuration = this.configurationAdmin.getConfiguration("org.apache.karaf.cellar.node", null);
            if (configuration != null && (properties = configuration.getProperties()) != null) {
                properties.put("handler." + handler, switchStatus.getValue().toString());
                configuration.update(properties);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Can't persist the handler {} status", (Object)handler, (Object)e);
        }
    }

    @Override
    public Class<ManageHandlersCommand> getType() {
        return ManageHandlersCommand.class;
    }

    @Override
    public Switch getSwitch() {
        return this.commandSwitch;
    }

    public void setProxyManager(ProxyManager proxyManager) {
        this.proxyManager = proxyManager;
    }
}

