/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.scr.state;

import org.apache.karaf.bundle.core.BundleState;
import org.apache.karaf.bundle.core.BundleStateService;
import org.osgi.framework.Bundle;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentConfigurationDTO;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;
import org.osgi.service.component.runtime.dto.UnsatisfiedReferenceDTO;

public class ScrBundleStateService
implements BundleStateService {
    ServiceComponentRuntime scr;

    public ScrBundleStateService(ServiceComponentRuntime scr) {
        this.scr = scr;
    }

    public String getName() {
        return "Declarative Services";
    }

    public String getDiag(Bundle bundle) {
        StringBuilder sb = new StringBuilder();
        for (ComponentDescriptionDTO desc : this.scr.getComponentDescriptionDTOs(new Bundle[]{bundle})) {
            for (ComponentConfigurationDTO cfg : this.scr.getComponentConfigurationDTOs(desc)) {
                boolean first;
                if (cfg.state == 8 || cfg.state == 4) continue;
                sb.append(cfg.description.name).append(" (").append(cfg.id).append(")\n");
                if ((cfg.state & 1) != 0) {
                    sb.append("  missing configurations: ");
                    first = true;
                    for (String string : cfg.description.configurationPid) {
                        if (!first) {
                            sb.append(", ");
                        }
                        sb.append(string);
                        first = false;
                    }
                    sb.append("\n");
                }
                if ((cfg.state & 2) == 0) continue;
                sb.append("  missing references: ");
                first = true;
                for (String string : cfg.unsatisfiedReferences) {
                    if (!first) {
                        sb.append(", ");
                    }
                    sb.append(((UnsatisfiedReferenceDTO)string).name);
                    first = false;
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public BundleState getState(Bundle bundle) {
        if (bundle.getState() == 32) {
            for (ComponentDescriptionDTO desc : this.scr.getComponentDescriptionDTOs(new Bundle[]{bundle})) {
                for (ComponentConfigurationDTO cfg : this.scr.getComponentConfigurationDTOs(desc)) {
                    if (cfg.state == 8 || cfg.state == 4) continue;
                    return BundleState.Waiting;
                }
            }
        }
        return BundleState.Unknown;
    }
}

