/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security.user.privileges;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;

public final class ApplicationResourcePrivileges
implements ToXContentObject {
    private static final ParseField APPLICATION = new ParseField("application", new String[0]);
    private static final ParseField PRIVILEGES = new ParseField("privileges", new String[0]);
    private static final ParseField RESOURCES = new ParseField("resources", new String[0]);
    static final ConstructingObjectParser<ApplicationResourcePrivileges, Void> PARSER = new ConstructingObjectParser("application_privileges", false, constructorObjects -> {
        int i = 0;
        String application = (String)constructorObjects[i++];
        Collection privileges = (Collection)constructorObjects[i++];
        Collection resources = (Collection)constructorObjects[i];
        return new ApplicationResourcePrivileges(application, privileges, resources);
    });
    private final String application;
    private final Set<String> privileges;
    private final Set<String> resources;

    public ApplicationResourcePrivileges(String application, Collection<String> privileges, Collection<String> resources) {
        if (Strings.isNullOrEmpty(application)) {
            throw new IllegalArgumentException("application privileges must have an application name");
        }
        if (null == privileges || privileges.isEmpty()) {
            throw new IllegalArgumentException("application privileges must define at least one privilege");
        }
        if (null == resources || resources.isEmpty()) {
            throw new IllegalArgumentException("application privileges must refer to at least one resource");
        }
        this.application = application;
        this.privileges = Collections.unmodifiableSet(new HashSet<String>(privileges));
        this.resources = Collections.unmodifiableSet(new HashSet<String>(resources));
    }

    public String getApplication() {
        return this.application;
    }

    public Set<String> getResources() {
        return this.resources;
    }

    public Set<String> getPrivileges() {
        return this.privileges;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationResourcePrivileges that = (ApplicationResourcePrivileges)o;
        return this.application.equals(that.application) && this.privileges.equals(that.privileges) && this.resources.equals(that.resources);
    }

    public int hashCode() {
        return Objects.hash(this.application, this.privileges, this.resources);
    }

    public String toString() {
        try {
            return XContentHelper.toXContent(this, XContentType.JSON, true).utf8ToString();
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected", e);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(APPLICATION.getPreferredName(), this.application);
        builder.field(PRIVILEGES.getPreferredName(), this.privileges);
        builder.field(RESOURCES.getPreferredName(), this.resources);
        return builder.endObject();
    }

    public static ApplicationResourcePrivileges fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), APPLICATION);
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), PRIVILEGES);
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), RESOURCES);
    }
}

