/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.network;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.network.NetworkUtils;

public final class IfConfig {
    private static final Logger logger = LogManager.getLogger(IfConfig.class);
    private static final String INDENT = "        ";

    public static void logIfNecessary() {
        if (logger.isDebugEnabled()) {
            try {
                IfConfig.doLogging();
            }
            catch (IOException e) {
                logger.warn("unable to gather network information", (Throwable)e);
            }
        }
    }

    private static void doLogging() throws IOException {
        StringBuilder msg = new StringBuilder();
        for (NetworkInterface nic : NetworkUtils.getInterfaces()) {
            msg.append(System.lineSeparator());
            msg.append(nic.getName());
            msg.append(System.lineSeparator());
            if (!nic.getName().equals(nic.getDisplayName())) {
                msg.append(INDENT);
                msg.append(nic.getDisplayName());
                msg.append(System.lineSeparator());
            }
            List<InterfaceAddress> addresses = nic.getInterfaceAddresses();
            for (InterfaceAddress address : addresses) {
                if (address.getAddress() instanceof Inet6Address) continue;
                msg.append(INDENT);
                msg.append(IfConfig.formatAddress(address));
                msg.append(System.lineSeparator());
            }
            for (InterfaceAddress address : addresses) {
                if (!(address.getAddress() instanceof Inet6Address)) continue;
                msg.append(INDENT);
                msg.append(IfConfig.formatAddress(address));
                msg.append(System.lineSeparator());
            }
            byte[] hardware = nic.getHardwareAddress();
            if (hardware != null) {
                msg.append(INDENT);
                msg.append("hardware ");
                for (int i = 0; i < hardware.length; ++i) {
                    if (i > 0) {
                        msg.append(":");
                    }
                    msg.append(String.format(Locale.ROOT, "%02X", hardware[i]));
                }
                msg.append(System.lineSeparator());
            }
            msg.append(INDENT);
            msg.append(IfConfig.formatFlags(nic));
            msg.append(System.lineSeparator());
        }
        logger.debug("configuration:{}{}", (Object)System.lineSeparator(), (Object)msg);
    }

    private static String formatAddress(InterfaceAddress interfaceAddress) throws IOException {
        StringBuilder sb = new StringBuilder();
        InetAddress address = interfaceAddress.getAddress();
        if (address instanceof Inet6Address) {
            sb.append("inet6 ");
            sb.append(NetworkAddress.format(address));
            sb.append(" prefixlen:");
            sb.append(interfaceAddress.getNetworkPrefixLength());
        } else {
            sb.append("inet ");
            sb.append(NetworkAddress.format(address));
            int netmask = -1 << 32 - interfaceAddress.getNetworkPrefixLength();
            sb.append(" netmask:").append(NetworkAddress.format(InetAddress.getByAddress(new byte[]{(byte)(netmask >>> 24), (byte)(netmask >>> 16 & 0xFF), (byte)(netmask >>> 8 & 0xFF), (byte)(netmask & 0xFF)})));
            InetAddress broadcast = interfaceAddress.getBroadcast();
            if (broadcast != null) {
                sb.append(" broadcast:").append(NetworkAddress.format(broadcast));
            }
        }
        if (address.isLoopbackAddress()) {
            sb.append(" scope:host");
        } else if (address.isLinkLocalAddress()) {
            sb.append(" scope:link");
        } else if (address.isSiteLocalAddress()) {
            sb.append(" scope:site");
        }
        return sb.toString();
    }

    private static String formatFlags(NetworkInterface nic) throws SocketException {
        StringBuilder flags = new StringBuilder();
        if (nic.isUp()) {
            flags.append("UP ");
        }
        if (nic.supportsMulticast()) {
            flags.append("MULTICAST ");
        }
        if (nic.isLoopback()) {
            flags.append("LOOPBACK ");
        }
        if (nic.isPointToPoint()) {
            flags.append("POINTOPOINT ");
        }
        if (nic.isVirtual()) {
            flags.append("VIRTUAL ");
        }
        flags.append("mtu:").append(nic.getMTU());
        flags.append(" index:").append(nic.getIndex());
        return flags.toString();
    }
}

