/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http;

import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.http.HttpTransportSettings;

public class HttpHandlingSettings {
    private final int maxContentLength;
    private final int maxChunkSize;
    private final int maxHeaderSize;
    private final int maxInitialLineLength;
    private final boolean resetCookies;
    private final boolean compression;
    private final int compressionLevel;
    private final boolean detailedErrorsEnabled;
    private final int pipeliningMaxEvents;
    private final long readTimeoutMillis;
    private boolean corsEnabled;

    public HttpHandlingSettings(int maxContentLength, int maxChunkSize, int maxHeaderSize, int maxInitialLineLength, boolean resetCookies, boolean compression, int compressionLevel, boolean detailedErrorsEnabled, int pipeliningMaxEvents, long readTimeoutMillis, boolean corsEnabled) {
        this.maxContentLength = maxContentLength;
        this.maxChunkSize = maxChunkSize;
        this.maxHeaderSize = maxHeaderSize;
        this.maxInitialLineLength = maxInitialLineLength;
        this.resetCookies = resetCookies;
        this.compression = compression;
        this.compressionLevel = compressionLevel;
        this.detailedErrorsEnabled = detailedErrorsEnabled;
        this.pipeliningMaxEvents = pipeliningMaxEvents;
        this.readTimeoutMillis = readTimeoutMillis;
        this.corsEnabled = corsEnabled;
    }

    public static HttpHandlingSettings fromSettings(Settings settings) {
        return new HttpHandlingSettings(Math.toIntExact(HttpTransportSettings.SETTING_HTTP_MAX_CONTENT_LENGTH.get(settings).getBytes()), Math.toIntExact(HttpTransportSettings.SETTING_HTTP_MAX_CHUNK_SIZE.get(settings).getBytes()), Math.toIntExact(HttpTransportSettings.SETTING_HTTP_MAX_HEADER_SIZE.get(settings).getBytes()), Math.toIntExact(HttpTransportSettings.SETTING_HTTP_MAX_INITIAL_LINE_LENGTH.get(settings).getBytes()), HttpTransportSettings.SETTING_HTTP_RESET_COOKIES.get(settings), HttpTransportSettings.SETTING_HTTP_COMPRESSION.get(settings), HttpTransportSettings.SETTING_HTTP_COMPRESSION_LEVEL.get(settings), HttpTransportSettings.SETTING_HTTP_DETAILED_ERRORS_ENABLED.get(settings), HttpTransportSettings.SETTING_PIPELINING_MAX_EVENTS.get(settings), HttpTransportSettings.SETTING_HTTP_READ_TIMEOUT.get(settings).getMillis(), HttpTransportSettings.SETTING_CORS_ENABLED.get(settings));
    }

    public int getMaxContentLength() {
        return this.maxContentLength;
    }

    public int getMaxChunkSize() {
        return this.maxChunkSize;
    }

    public int getMaxHeaderSize() {
        return this.maxHeaderSize;
    }

    public int getMaxInitialLineLength() {
        return this.maxInitialLineLength;
    }

    public boolean isResetCookies() {
        return this.resetCookies;
    }

    public boolean isCompression() {
        return this.compression;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public boolean getDetailedErrorsEnabled() {
        return this.detailedErrorsEnabled;
    }

    public int getPipeliningMaxEvents() {
        return this.pipeliningMaxEvents;
    }

    public long getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    public boolean isCorsEnabled() {
        return this.corsEnabled;
    }
}

