/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.analysis.Tokenizer;
import org.elasticsearch.Version;
import org.elasticsearch.index.analysis.PreConfiguredAnalysisComponent;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.indices.analysis.PreBuiltCacheFactory;

public final class PreConfiguredTokenizer
extends PreConfiguredAnalysisComponent<TokenizerFactory> {
    private final Function<Version, Tokenizer> create;

    public static PreConfiguredTokenizer singleton(String name, Supplier<Tokenizer> create) {
        return new PreConfiguredTokenizer(name, PreBuiltCacheFactory.CachingStrategy.ONE, version -> (Tokenizer)create.get());
    }

    public static PreConfiguredTokenizer luceneVersion(String name, Function<org.apache.lucene.util.Version, Tokenizer> create) {
        return new PreConfiguredTokenizer(name, PreBuiltCacheFactory.CachingStrategy.LUCENE, version -> (Tokenizer)create.apply(version.luceneVersion));
    }

    public static PreConfiguredTokenizer elasticsearchVersion(String name, Function<Version, Tokenizer> create) {
        return new PreConfiguredTokenizer(name, PreBuiltCacheFactory.CachingStrategy.ELASTICSEARCH, create);
    }

    private PreConfiguredTokenizer(String name, PreBuiltCacheFactory.CachingStrategy cache, Function<Version, Tokenizer> create) {
        super(name, cache);
        this.create = create;
    }

    @Override
    protected TokenizerFactory create(Version version) {
        return TokenizerFactory.newFactory(this.name, () -> this.create.apply(version));
    }
}

