/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.LatLonDocValuesField;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.plain.AbstractLatLonPointDVIndexFieldData;
import org.elasticsearch.index.mapper.ArrayValueMapperParser;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.TypeParsers;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;

public class GeoPointFieldMapper
extends FieldMapper
implements ArrayValueMapperParser {
    public static final String CONTENT_TYPE = "geo_point";
    protected Explicit<Boolean> ignoreMalformed;
    protected Explicit<Boolean> ignoreZValue;

    public GeoPointFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Settings indexSettings, FieldMapper.MultiFields multiFields, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> ignoreZValue, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, indexSettings, multiFields, copyTo);
        this.ignoreMalformed = ignoreMalformed;
        this.ignoreZValue = ignoreZValue;
    }

    @Override
    protected void doMerge(Mapper mergeWith) {
        super.doMerge(mergeWith);
        GeoPointFieldMapper gpfmMergeWith = (GeoPointFieldMapper)mergeWith;
        if (gpfmMergeWith.ignoreMalformed.explicit()) {
            this.ignoreMalformed = gpfmMergeWith.ignoreMalformed;
        }
        if (gpfmMergeWith.ignoreZValue.explicit()) {
            this.ignoreZValue = gpfmMergeWith.ignoreZValue;
        }
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        throw new UnsupportedOperationException("Parsing is implemented in parse(), this method should NEVER be called");
    }

    protected void parse(ParseContext context, GeoPoint point) throws IOException {
        if (!this.ignoreMalformed.value().booleanValue()) {
            if (point.lat() > 90.0 || point.lat() < -90.0) {
                throw new IllegalArgumentException("illegal latitude value [" + point.lat() + "] for " + this.name());
            }
            if (point.lon() > 180.0 || point.lon() < -180.0) {
                throw new IllegalArgumentException("illegal longitude value [" + point.lon() + "] for " + this.name());
            }
        } else if (this.isNormalizable(point.lat()) && this.isNormalizable(point.lon())) {
            GeoUtils.normalizePoint(point);
        } else {
            throw new ElasticsearchParseException("cannot normalize the point - not a number", new Object[0]);
        }
        if (this.fieldType().indexOptions() != IndexOptions.NONE) {
            context.doc().add((IndexableField)new LatLonPoint(this.fieldType().name(), point.lat(), point.lon()));
        }
        if (this.fieldType().stored()) {
            context.doc().add((IndexableField)new StoredField(this.fieldType().name(), point.toString()));
        }
        if (this.fieldType.hasDocValues()) {
            context.doc().add((IndexableField)new LatLonDocValuesField(this.fieldType().name(), point.lat(), point.lon()));
        } else if (this.fieldType().stored() || this.fieldType().indexOptions() != IndexOptions.NONE) {
            ArrayList<IndexableField> fields = new ArrayList<IndexableField>(1);
            this.createFieldNamesField(context, fields);
            for (IndexableField field : fields) {
                context.doc().add(field);
            }
        }
        if (this.multiFields.iterator().hasNext()) {
            this.multiFields.parse(this, context.createExternalValueContext(point.geohash()));
        }
    }

    @Override
    public void parse(ParseContext context) throws IOException {
        context.path().add(this.simpleName());
        try {
            GeoPoint sparse = context.parseExternalValue(GeoPoint.class);
            if (sparse != null) {
                this.parse(context, sparse);
            } else {
                sparse = new GeoPoint();
                XContentParser.Token token = context.parser().currentToken();
                if (token == XContentParser.Token.START_ARRAY) {
                    token = context.parser().nextToken();
                    if (token == XContentParser.Token.VALUE_NUMBER) {
                        double lon = context.parser().doubleValue();
                        context.parser().nextToken();
                        double lat = context.parser().doubleValue();
                        token = context.parser().nextToken();
                        if (token == XContentParser.Token.VALUE_NUMBER) {
                            GeoPoint.assertZValue(this.ignoreZValue.value(), context.parser().doubleValue());
                        } else if (token != XContentParser.Token.END_ARRAY) {
                            throw new ElasticsearchParseException("[{}] field type does not accept > 3 dimensions", CONTENT_TYPE);
                        }
                        this.parse(context, sparse.reset(lat, lon));
                    } else {
                        while (token != XContentParser.Token.END_ARRAY) {
                            this.parseGeoPointIgnoringMalformed(context, sparse);
                            token = context.parser().nextToken();
                        }
                    }
                } else if (token == XContentParser.Token.VALUE_NULL) {
                    if (this.fieldType.nullValue() != null) {
                        this.parse(context, (GeoPoint)this.fieldType.nullValue());
                    }
                } else {
                    this.parseGeoPointIgnoringMalformed(context, sparse);
                }
            }
        }
        catch (Exception ex) {
            throw new MapperParsingException("failed to parse field [{}] of type [{}]", (Throwable)ex, this.fieldType().name(), this.fieldType().typeName());
        }
        context.path().remove();
    }

    private void parseGeoPointIgnoringMalformed(ParseContext context, GeoPoint sparse) throws IOException {
        try {
            this.parse(context, GeoUtils.parseGeoPoint(context.parser(), sparse, this.ignoreZValue.value()));
        }
        catch (ElasticsearchParseException e) {
            if (!this.ignoreMalformed.value().booleanValue()) {
                throw e;
            }
            context.addIgnoredField(this.fieldType.name());
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.ignoreMalformed.explicit()) {
            builder.field("ignore_malformed", this.ignoreMalformed.value());
        }
        if (includeDefaults || this.ignoreZValue.explicit()) {
            builder.field(Names.IGNORE_Z_VALUE.getPreferredName(), this.ignoreZValue.value());
        }
        if (includeDefaults || this.fieldType().nullValue() != null) {
            builder.field("null_value", this.fieldType().nullValue());
        }
    }

    public Explicit<Boolean> ignoreZValue() {
        return this.ignoreZValue;
    }

    private boolean isNormalizable(double coord) {
        return !Double.isNaN(coord) && !Double.isInfinite(coord);
    }

    public static class GeoPointFieldType
    extends MappedFieldType {
        public GeoPointFieldType() {
        }

        GeoPointFieldType(GeoPointFieldType ref) {
            super(ref);
        }

        @Override
        public String typeName() {
            return GeoPointFieldMapper.CONTENT_TYPE;
        }

        @Override
        public MappedFieldType clone() {
            return new GeoPointFieldType(this);
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName) {
            this.failIfNoDocValues();
            return new AbstractLatLonPointDVIndexFieldData.Builder();
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            if (this.hasDocValues()) {
                return new DocValuesFieldExistsQuery(this.name());
            }
            return new TermQuery(new Term("_field_names", this.name()));
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            throw new QueryShardException(context, "Geo fields do not support exact searching, use dedicated geo queries instead: [" + this.name() + "]", new Object[0]);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            TypeParsers.parseField(builder, name, node, parserContext);
            Object nullValue = null;
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                if (propName.equals("ignore_malformed")) {
                    builder.ignoreMalformed(XContentMapValues.nodeBooleanValue(propNode, name + "." + "ignore_malformed"));
                    iterator.remove();
                    continue;
                }
                if (propName.equals(Names.IGNORE_Z_VALUE.getPreferredName())) {
                    builder.ignoreZValue(XContentMapValues.nodeBooleanValue(propNode, name + "." + Names.IGNORE_Z_VALUE.getPreferredName()));
                    iterator.remove();
                    continue;
                }
                if (!propName.equals("null_value")) continue;
                if (propNode == null) {
                    throw new MapperParsingException("Property [null_value] cannot be null.");
                }
                nullValue = propNode;
                iterator.remove();
            }
            if (nullValue != null) {
                boolean ignoreZValue = builder.ignoreZValue == null ? Defaults.IGNORE_Z_VALUE.value() : builder.ignoreZValue;
                boolean ignoreMalformed = builder.ignoreMalformed == null ? Defaults.IGNORE_MALFORMED.value() : builder.ignoreZValue;
                GeoPoint point = GeoUtils.parseGeoPoint(nullValue, ignoreZValue);
                if (!ignoreMalformed) {
                    if (point.lat() > 90.0 || point.lat() < -90.0) {
                        throw new IllegalArgumentException("illegal latitude value [" + point.lat() + "]");
                    }
                    if (point.lon() > 180.0 || point.lon() < -180.0) {
                        throw new IllegalArgumentException("illegal longitude value [" + point.lon() + "]");
                    }
                } else {
                    GeoUtils.normalizePoint(point);
                }
                builder.nullValue(point);
            }
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder, GeoPointFieldMapper> {
        protected Boolean ignoreMalformed;
        private Boolean ignoreZValue;

        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        public Builder ignoreMalformed(boolean ignoreMalformed) {
            this.ignoreMalformed = ignoreMalformed;
            return (Builder)this.builder;
        }

        protected Explicit<Boolean> ignoreMalformed(Mapper.BuilderContext context) {
            if (this.ignoreMalformed != null) {
                return new Explicit<Boolean>(this.ignoreMalformed, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit<Boolean>(FieldMapper.IGNORE_MALFORMED_SETTING.get(context.indexSettings()), false);
            }
            return Defaults.IGNORE_MALFORMED;
        }

        protected Explicit<Boolean> ignoreZValue(Mapper.BuilderContext context) {
            if (this.ignoreZValue != null) {
                return new Explicit<Boolean>(this.ignoreZValue, true);
            }
            return Defaults.IGNORE_Z_VALUE;
        }

        public Builder ignoreZValue(boolean ignoreZValue) {
            this.ignoreZValue = ignoreZValue;
            return this;
        }

        public GeoPointFieldMapper build(Mapper.BuilderContext context, String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Settings indexSettings, FieldMapper.MultiFields multiFields, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> ignoreZValue, FieldMapper.CopyTo copyTo) {
            this.setupFieldType(context);
            return new GeoPointFieldMapper(simpleName, fieldType, defaultFieldType, indexSettings, multiFields, ignoreMalformed, ignoreZValue, copyTo);
        }

        @Override
        public GeoPointFieldMapper build(Mapper.BuilderContext context) {
            return this.build(context, this.name, this.fieldType, this.defaultFieldType, context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.ignoreMalformed(context), this.ignoreZValue(context), this.copyTo);
        }
    }

    public static class Defaults {
        public static final Explicit<Boolean> IGNORE_MALFORMED = new Explicit<Boolean>(false, false);
        public static final GeoPointFieldType FIELD_TYPE = new GeoPointFieldType();
        public static final Explicit<Boolean> IGNORE_Z_VALUE = new Explicit<Boolean>(true, false);

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setHasDocValues(true);
            FIELD_TYPE.setDimensions(2, 4);
            FIELD_TYPE.freeze();
        }
    }

    public static class Names {
        public static final String IGNORE_MALFORMED = "ignore_malformed";
        public static final ParseField IGNORE_Z_VALUE = new ParseField("ignore_z_value", new String[0]);
        public static final String NULL_VALUE = "null_value";
    }
}

