/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public final class IndexId
implements Writeable,
ToXContentObject {
    protected static final String NAME = "name";
    protected static final String ID = "id";
    private final String name;
    private final String id;
    private final int hashCode;

    public IndexId(String name, String id) {
        this.name = name;
        this.id = id;
        this.hashCode = this.computeHashCode();
    }

    public IndexId(StreamInput in) throws IOException {
        this.name = in.readString();
        this.id = in.readString();
        this.hashCode = this.computeHashCode();
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return "[" + this.name + "/" + this.id + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexId that = (IndexId)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        return Objects.hash(this.name, this.id);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.id);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NAME, this.name);
        builder.field(ID, this.id);
        builder.endObject();
        return builder;
    }
}

