/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.features.shell;

import java.util.List;
import java.util.Map;
import org.apache.karaf.cellar.core.CellarSupport;
import org.apache.karaf.cellar.core.Group;
import org.apache.karaf.cellar.core.control.SwitchStatus;
import org.apache.karaf.cellar.core.event.Event;
import org.apache.karaf.cellar.core.event.EventProducer;
import org.apache.karaf.cellar.core.event.EventType;
import org.apache.karaf.cellar.core.shell.CellarCommandSupport;
import org.apache.karaf.cellar.core.shell.completer.AllGroupsCompleter;
import org.apache.karaf.cellar.features.ClusterFeaturesEvent;
import org.apache.karaf.cellar.features.FeatureState;
import org.apache.karaf.features.FeatureEvent;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.command.completers.AllFeatureCompleter;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="cluster", name="feature-install", description="Install a feature in a cluster group")
@Service
public class InstallFeatureCommand
extends CellarCommandSupport {
    @Option(name="-r", aliases={"--no-auto-refresh"}, description="Do not automatically refresh bundles", required=false, multiValued=false)
    boolean noRefresh;
    @Option(name="-s", aliases={"--no-auto-start"}, description="Do not start the bundles", required=false, multiValued=false)
    boolean noStart;
    @Option(name="-m", aliases={"--no-auto-manager"}, description="Do not automatically manage bundles", required=false, multiValued=false)
    boolean noManage;
    @Option(name="-u", aliases={"--upgrade"}, description="Perform an upgrade of feature if previous version are installed or install it", required=false, multiValued=false)
    boolean upgrade;
    @Argument(index=0, name="group", description="The cluster group name", required=true, multiValued=false)
    @Completion(value=AllGroupsCompleter.class)
    String groupName;
    @Argument(index=1, name="features", description="The name and version of the features to install. A feature id looks like name/version. The version is optional.", required=true, multiValued=true)
    @Completion(value=AllFeatureCompleter.class)
    List<String> features;
    @Reference
    private EventProducer eventProducer;
    @Reference
    private FeaturesService featuresService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doExecute() throws Exception {
        Group group = this.groupManager.findGroupByName(this.groupName);
        if (group == null) {
            System.err.println("Cluster group " + this.groupName + " doesn't exist");
            return null;
        }
        if (this.eventProducer.getSwitch().getStatus().equals((Object)SwitchStatus.OFF)) {
            System.err.println("Cluster event producer is OFF");
            return null;
        }
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        try {
            Map clusterFeatures = this.clusterManager.getMap("org.apache.karaf.cellar.features." + this.groupName);
            CellarSupport support = new CellarSupport();
            support.setClusterManager(this.clusterManager);
            support.setConfigurationAdmin(this.configurationAdmin);
            support.setGroupManager(this.groupManager);
            for (String feature : this.features) {
                String[] split = feature.split("/");
                String name = split[0];
                String version = null;
                if (split.length == 2) {
                    version = split[1];
                }
                FeatureState found = null;
                String foundKey = null;
                for (String k : clusterFeatures.keySet()) {
                    FeatureState f = (FeatureState)clusterFeatures.get(k);
                    foundKey = k;
                    if (version == null) {
                        if (!f.getName().equals(name)) continue;
                        found = f;
                        break;
                    }
                    if (!f.getName().equals(name) || !f.getVersion().equals(version)) continue;
                    found = f;
                    break;
                }
                if (found == null) {
                    if (version == null) {
                        throw new IllegalArgumentException("Feature " + name + " doesn't exist in cluster group " + this.groupName);
                    }
                    throw new IllegalArgumentException("Feature " + name + "/" + version + " doesn't exist in cluster group " + this.groupName);
                }
                if (support.isAllowed(group, "feature", found.getName(), EventType.OUTBOUND).booleanValue()) {
                    found.setInstalled(true);
                    clusterFeatures.put(foundKey, found);
                    ClusterFeaturesEvent event = new ClusterFeaturesEvent(found.getName(), found.getVersion(), this.noRefresh, this.noStart, this.noManage, this.upgrade, FeatureEvent.EventType.FeatureInstalled);
                    event.setSourceGroup(group);
                    this.eventProducer.produce((Event)event);
                    continue;
                }
                System.err.println("Feature name " + found.getName() + " is blocked outbound for cluster group " + this.groupName);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return null;
    }

    public EventProducer getEventProducer() {
        return this.eventProducer;
    }

    public void setEventProducer(EventProducer eventProducer) {
        this.eventProducer = eventProducer;
    }

    public FeaturesService getFeaturesService() {
        return this.featuresService;
    }

    public void setFeaturesService(FeaturesService featuresService) {
        this.featuresService = featuresService;
    }
}

