/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.util;

import com.hazelcast.client.impl.clientside.ClientMessageDecoder;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.ExceptionUtil;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class ClientDelegatingFuture<V>
implements InternalCompletableFuture<V> {
    private static final AtomicReferenceFieldUpdater<ClientDelegatingFuture, Object> DECODED_RESPONSE = AtomicReferenceFieldUpdater.newUpdater(ClientDelegatingFuture.class, Object.class, "decodedResponse");
    private static final Object VOID = "VOID";
    private final ClientInvocationFuture future;
    private final SerializationService serializationService;
    private final ClientMessageDecoder clientMessageDecoder;
    private final boolean deserializeResponse;
    private final V defaultValue;
    private final Executor userExecutor;
    private volatile Object decodedResponse = VOID;

    public ClientDelegatingFuture(ClientInvocationFuture clientInvocationFuture, SerializationService serializationService, ClientMessageDecoder clientMessageDecoder, V defaultValue, boolean deserializeResponse) {
        this.future = clientInvocationFuture;
        this.serializationService = serializationService;
        this.clientMessageDecoder = clientMessageDecoder;
        this.defaultValue = defaultValue;
        this.userExecutor = clientInvocationFuture.getInvocation().getUserExecutor();
        this.deserializeResponse = deserializeResponse;
    }

    public ClientDelegatingFuture(ClientInvocationFuture clientInvocationFuture, SerializationService serializationService, ClientMessageDecoder clientMessageDecoder, V defaultValue) {
        this(clientInvocationFuture, serializationService, clientMessageDecoder, defaultValue, true);
    }

    public ClientDelegatingFuture(ClientInvocationFuture clientInvocationFuture, SerializationService serializationService, ClientMessageDecoder clientMessageDecoder) {
        this(clientInvocationFuture, serializationService, clientMessageDecoder, null, true);
    }

    public ClientDelegatingFuture(ClientInvocationFuture clientInvocationFuture, SerializationService serializationService, ClientMessageDecoder clientMessageDecoder, boolean deserializeResponse) {
        this(clientInvocationFuture, serializationService, clientMessageDecoder, null, deserializeResponse);
    }

    @Override
    public void andThen(ExecutionCallback<V> callback) {
        this.future.andThen(new DelegatingExecutionCallback<V>(callback, this.deserializeResponse), this.userExecutor);
    }

    @Override
    public void andThen(ExecutionCallback<V> callback, Executor executor) {
        this.future.andThen(new DelegatingExecutionCallback<V>(callback, this.deserializeResponse), executor);
    }

    @Override
    public boolean complete(Object value) {
        return this.future.complete(value);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.future.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public final boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        try {
            return this.get(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            return (V)ExceptionUtil.sneakyThrow(e);
        }
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        ClientMessage response = (ClientMessage)this.future.get(timeout, unit);
        return (V)this.resolveResponse(response, this.deserializeResponse);
    }

    @Override
    public V join() {
        try {
            return this.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    private Object resolveResponse(ClientMessage clientMessage, boolean deserialize) {
        if (this.defaultValue != null) {
            return this.defaultValue;
        }
        Object decodedResponse = this.decodeResponse(clientMessage);
        if (deserialize) {
            return this.serializationService.toObject(decodedResponse);
        }
        return decodedResponse;
    }

    private Object decodeResponse(ClientMessage clientMessage) {
        if (this.decodedResponse != VOID) {
            return this.decodedResponse;
        }
        ClientMessage message = ClientMessage.createForDecode(clientMessage.buffer(), 0);
        Object newDecodedResponse = this.clientMessageDecoder.decodeClientMessage(message);
        DECODED_RESPONSE.compareAndSet(this, VOID, newDecodedResponse);
        return newDecodedResponse;
    }

    protected ClientInvocationFuture getFuture() {
        return this.future;
    }

    class DelegatingExecutionCallback<T>
    implements ExecutionCallback<ClientMessage> {
        private final ExecutionCallback<T> callback;
        private final boolean deserialize;

        DelegatingExecutionCallback(ExecutionCallback<T> callback, boolean deserialize) {
            this.callback = callback;
            this.deserialize = deserialize;
        }

        @Override
        public void onResponse(ClientMessage message) {
            Object response = ClientDelegatingFuture.this.resolveResponse(message, this.deserialize);
            this.callback.onResponse(response);
        }

        @Override
        public void onFailure(Throwable t) {
            this.callback.onFailure(t);
        }
    }
}

