/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.region;

import com.hazelcast.hibernate.access.AccessDelegate;
import com.hazelcast.hibernate.region.HazelcastCacheKeysFactory;
import com.hazelcast.hibernate.region.HazelcastCollectionRegion;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.CacheKeysFactory;
import org.hibernate.cache.spi.CollectionRegion;
import org.hibernate.cache.spi.access.CollectionRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;

public final class CollectionRegionAccessStrategyAdapter
implements CollectionRegionAccessStrategy {
    private final AccessDelegate<? extends HazelcastCollectionRegion> delegate;
    private final CacheKeysFactory cacheKeysFactory = new HazelcastCacheKeysFactory();

    public CollectionRegionAccessStrategyAdapter(AccessDelegate<? extends HazelcastCollectionRegion> delegate) {
        this.delegate = delegate;
    }

    public void evict(Object key) throws CacheException {
        this.delegate.evict(key);
    }

    public void evictAll() throws CacheException {
        this.delegate.evictAll();
    }

    public Object generateCacheKey(Object id, CollectionPersister persister, SessionFactoryImplementor session, String tenantIdentifier) {
        return this.cacheKeysFactory.createCollectionKey(id, persister, session, tenantIdentifier);
    }

    public Object get(SessionImplementor session, Object key, long txTimestamp) throws CacheException {
        return this.delegate.get(key, txTimestamp);
    }

    public Object getCacheKeyId(Object cacheKey) {
        return this.cacheKeysFactory.getCollectionId(cacheKey);
    }

    public CollectionRegion getRegion() {
        return this.delegate.getHazelcastRegion();
    }

    public SoftLock lockItem(SessionImplementor session, Object key, Object version) throws CacheException {
        return this.delegate.lockItem(key, version);
    }

    public SoftLock lockRegion() throws CacheException {
        return this.delegate.lockRegion();
    }

    public boolean putFromLoad(SessionImplementor session, Object key, Object value, long txTimestamp, Object version) throws CacheException {
        return this.delegate.putFromLoad(key, value, txTimestamp, version);
    }

    public boolean putFromLoad(SessionImplementor session, Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) throws CacheException {
        return this.delegate.putFromLoad(key, value, txTimestamp, version, minimalPutOverride);
    }

    public void remove(SessionImplementor session, Object key) throws CacheException {
        this.delegate.remove(key);
    }

    public void removeAll() throws CacheException {
        this.delegate.removeAll();
    }

    public void unlockItem(SessionImplementor session, Object key, SoftLock lock) throws CacheException {
        this.delegate.unlockItem(key, lock);
    }

    public void unlockRegion(SoftLock lock) throws CacheException {
        this.delegate.unlockRegion(lock);
    }
}

