/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.bundle.core.internal;

import java.io.File;
import java.io.FileInputStream;
import java.util.Dictionary;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenConfigService {
    private static final Logger logger = LoggerFactory.getLogger(MavenConfigService.class);
    private final ConfigurationAdmin configurationAdmin;

    public MavenConfigService(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    File getLocalRepository() {
        int index;
        String path = null;
        Dictionary<String, Object> config = this.getConfiguration();
        if (config != null) {
            path = MavenConfigService.getLocalRepoFromConfig(config);
        }
        if (path == null) {
            path = System.getProperty("user.home") + File.separator + ".m2" + File.separator + "repository";
        }
        if ((index = path.indexOf(64)) > 0) {
            return new File(path.substring(index)).getAbsoluteFile();
        }
        return new File(path).getAbsoluteFile();
    }

    private Dictionary<String, Object> getConfiguration() {
        try {
            Configuration configuration = this.configurationAdmin.getConfiguration("org.ops4j.pax.url.mvn", null);
            if (configuration != null) {
                return configuration.getProperties();
            }
        }
        catch (Exception e) {
            logger.error("Error retrieving maven configuration", (Throwable)e);
        }
        return null;
    }

    static String getLocalRepoFromConfig(Dictionary<String, Object> dict) {
        String settings;
        String path = null;
        if (dict != null && (path = (String)dict.get("org.ops4j.pax.url.mvn.localRepository")) == null && (settings = (String)dict.get("org.ops4j.pax.url.mvn.settings")) != null) {
            path = MavenConfigService.getLocalRepositoryFromSettings(new File(settings));
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getLocalRepositoryFromSettings(File file) {
        XMLStreamReader reader = null;
        try (FileInputStream fin = new FileInputStream(file);){
            int event;
            reader = XMLInputFactory.newFactory().createXMLStreamReader(fin);
            String elementName = null;
            while ((event = reader.next()) != 8) {
                if (event == 1) {
                    elementName = reader.getLocalName();
                    continue;
                }
                if (event == 2) {
                    elementName = null;
                    continue;
                }
                if (event != 4 || !"localRepository".equals(elementName)) continue;
                String string = reader.getText().trim();
                return string;
            }
        }
        catch (Exception e) {
            logger.error("Error retrieving maven configuration", (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
        }
        return null;
    }
}

