/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.ExpressionClause;
import org.apache.camel.model.OtherwiseDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.WhenDefinition;
import org.apache.camel.processor.ChoiceProcessor;
import org.apache.camel.processor.FilterProcessor;
import org.apache.camel.spi.AsPredicate;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.CollectionStringBuffer;
import org.apache.camel.util.ObjectHelper;

@Metadata(label="eip,routing")
@XmlRootElement(name="choice")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ChoiceDefinition
extends ProcessorDefinition<ChoiceDefinition> {
    @XmlElementRef
    @AsPredicate
    private List<WhenDefinition> whenClauses = new ArrayList<WhenDefinition>();
    @XmlElement
    private OtherwiseDefinition otherwise;
    private transient boolean onlyWhenOrOtherwise = true;

    @Override
    public List<ProcessorDefinition<?>> getOutputs() {
        return new AbstractList<ProcessorDefinition<?>>(){

            @Override
            public ProcessorDefinition<?> get(int index) {
                if (index < ChoiceDefinition.this.whenClauses.size()) {
                    return (ProcessorDefinition)ChoiceDefinition.this.whenClauses.get(index);
                }
                if (index == ChoiceDefinition.this.whenClauses.size()) {
                    return ChoiceDefinition.this.otherwise;
                }
                throw new IndexOutOfBoundsException("Index " + index + " is out of bounds with size " + this.size());
            }

            @Override
            public boolean add(ProcessorDefinition<?> def) {
                if (def instanceof WhenDefinition) {
                    return ChoiceDefinition.this.whenClauses.add((WhenDefinition)def);
                }
                if (def instanceof OtherwiseDefinition) {
                    ChoiceDefinition.this.otherwise = (OtherwiseDefinition)def;
                    return true;
                }
                throw new IllegalArgumentException("Expected either a WhenDefinition or OtherwiseDefinition but was " + ObjectHelper.classCanonicalName(def));
            }

            @Override
            public int size() {
                return ChoiceDefinition.this.whenClauses.size() + (ChoiceDefinition.this.otherwise == null ? 0 : 1);
            }

            @Override
            public void clear() {
                ChoiceDefinition.this.whenClauses.clear();
                ChoiceDefinition.this.otherwise = null;
            }

            @Override
            public ProcessorDefinition<?> set(int index, ProcessorDefinition<?> element) {
                if (index < ChoiceDefinition.this.whenClauses.size()) {
                    if (element instanceof WhenDefinition) {
                        return ChoiceDefinition.this.whenClauses.set(index, (WhenDefinition)element);
                    }
                    throw new IllegalArgumentException("Expected WhenDefinition but was " + ObjectHelper.classCanonicalName(element));
                }
                if (index == ChoiceDefinition.this.whenClauses.size()) {
                    OtherwiseDefinition old = ChoiceDefinition.this.otherwise;
                    ChoiceDefinition.this.otherwise = (OtherwiseDefinition)element;
                    return old;
                }
                throw new IndexOutOfBoundsException("Index " + index + " is out of bounds with size " + this.size());
            }

            @Override
            public ProcessorDefinition<?> remove(int index) {
                if (index < ChoiceDefinition.this.whenClauses.size()) {
                    return (ProcessorDefinition)ChoiceDefinition.this.whenClauses.remove(index);
                }
                if (index == ChoiceDefinition.this.whenClauses.size()) {
                    OtherwiseDefinition old = ChoiceDefinition.this.otherwise;
                    ChoiceDefinition.this.otherwise = null;
                    return old;
                }
                throw new IndexOutOfBoundsException("Index " + index + " is out of bounds with size " + this.size());
            }
        };
    }

    @Override
    public boolean isOutputSupported() {
        return true;
    }

    public String toString() {
        return "Choice[" + this.getWhenClauses() + (this.getOtherwise() != null ? " " + this.getOtherwise() : "") + "]";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        ArrayList<FilterProcessor> filters = new ArrayList<FilterProcessor>();
        for (WhenDefinition whenClause : this.whenClauses) {
            FilterProcessor filter = (FilterProcessor)this.createProcessor(routeContext, whenClause);
            filters.add(filter);
        }
        Processor otherwiseProcessor = null;
        if (this.otherwise != null) {
            otherwiseProcessor = this.createProcessor(routeContext, this.otherwise);
        }
        return new ChoiceProcessor(filters, otherwiseProcessor);
    }

    @Override
    public void addOutput(ProcessorDefinition<?> output) {
        if (this.onlyWhenOrOtherwise) {
            if (output instanceof WhenDefinition || output instanceof OtherwiseDefinition) {
                this.onlyWhenOrOtherwise = false;
            } else {
                throw new IllegalArgumentException("A new choice clause should start with a when() or otherwise(). If you intend to end the entire choice and are using endChoice() then use end() instead.");
            }
        }
        super.addOutput(output);
    }

    @Override
    public ProcessorDefinition<?> end() {
        this.onlyWhenOrOtherwise = true;
        return super.end();
    }

    @Override
    public ChoiceDefinition endChoice() {
        this.onlyWhenOrOtherwise = true;
        return super.endChoice();
    }

    public ChoiceDefinition when(@AsPredicate Predicate predicate) {
        this.addClause(new WhenDefinition(predicate));
        return this;
    }

    @AsPredicate
    public ExpressionClause<ChoiceDefinition> when() {
        ExpressionClause<ChoiceDefinition> clause = new ExpressionClause<ChoiceDefinition>(this);
        this.addClause(new WhenDefinition(clause));
        return clause;
    }

    private void addClause(ProcessorDefinition<?> when) {
        this.onlyWhenOrOtherwise = true;
        this.popBlock();
        this.addOutput(when);
        this.pushBlock(when);
    }

    public ChoiceDefinition otherwise() {
        OtherwiseDefinition answer = new OtherwiseDefinition();
        this.addClause(answer);
        return this;
    }

    @Override
    public void setId(String value) {
        if (this.otherwise != null) {
            this.otherwise.setId(value);
        } else if (!this.getWhenClauses().isEmpty()) {
            int size = this.getWhenClauses().size();
            this.getWhenClauses().get(size - 1).setId(value);
        } else {
            super.setId(value);
        }
    }

    @Override
    public String getLabel() {
        CollectionStringBuffer buffer = new CollectionStringBuffer("choice[");
        List<WhenDefinition> list = this.getWhenClauses();
        for (WhenDefinition whenType : list) {
            buffer.append(whenType.getLabel());
        }
        buffer.append("]");
        return buffer.toString();
    }

    public List<WhenDefinition> getWhenClauses() {
        return this.whenClauses;
    }

    public void setWhenClauses(List<WhenDefinition> whenClauses) {
        this.whenClauses = whenClauses;
    }

    public OtherwiseDefinition getOtherwise() {
        return this.otherwise;
    }

    public void setOtherwise(OtherwiseDefinition otherwise) {
        this.otherwise = otherwise;
    }

    @Override
    public void configureChild(ProcessorDefinition<?> output) {
        if (this.whenClauses == null || this.whenClauses.isEmpty()) {
            return;
        }
        for (WhenDefinition when : this.whenClauses) {
            ExpressionClause clause;
            if (!(when.getExpression() instanceof ExpressionClause) || (clause = (ExpressionClause)when.getExpression()).getExpressionType() == null) continue;
            when.setExpression(clause.getExpressionType());
        }
    }
}

