/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelException;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.kafka.KafkaEndpoint;
import org.apache.camel.impl.DefaultAsyncProducer;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.utils.Bytes;

public class KafkaProducer
extends DefaultAsyncProducer {
    private org.apache.kafka.clients.producer.KafkaProducer kafkaProducer;
    private final KafkaEndpoint endpoint;
    private ExecutorService workerPool;
    private boolean shutdownWorkerPool;

    public KafkaProducer(KafkaEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    Properties getProps() {
        Properties props = this.endpoint.getConfiguration().createProducerProperties();
        this.endpoint.updateClassProperties(props);
        String brokers = this.endpoint.getConfiguration().getBrokers();
        if (brokers == null) {
            brokers = this.endpoint.getComponent().getBrokers();
        }
        if (brokers == null) {
            throw new IllegalArgumentException("URL to the Kafka brokers must be configured with the brokers option on either the component or endpoint.");
        }
        props.put("bootstrap.servers", brokers);
        return props;
    }

    public org.apache.kafka.clients.producer.KafkaProducer getKafkaProducer() {
        return this.kafkaProducer;
    }

    public void setKafkaProducer(org.apache.kafka.clients.producer.KafkaProducer kafkaProducer) {
        this.kafkaProducer = kafkaProducer;
    }

    public ExecutorService getWorkerPool() {
        return this.workerPool;
    }

    public void setWorkerPool(ExecutorService workerPool) {
        this.workerPool = workerPool;
    }

    protected void doStart() throws Exception {
        Properties props = this.getProps();
        if (this.kafkaProducer == null) {
            ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(org.apache.kafka.clients.producer.KafkaProducer.class.getClassLoader());
                this.kafkaProducer = new org.apache.kafka.clients.producer.KafkaProducer(props);
            }
            finally {
                Thread.currentThread().setContextClassLoader(threadClassLoader);
            }
        }
        if (!this.endpoint.isSynchronous() && this.workerPool == null) {
            this.workerPool = this.endpoint.createProducerExecutor();
            this.shutdownWorkerPool = true;
        }
    }

    protected void doStop() throws Exception {
        if (this.kafkaProducer != null) {
            this.kafkaProducer.close();
        }
        if (this.shutdownWorkerPool && this.workerPool != null) {
            this.endpoint.getCamelContext().getExecutorServiceManager().shutdown(this.workerPool);
            this.workerPool = null;
        }
    }

    protected Iterator<ProducerRecord> createRecorder(final Exchange exchange) throws CamelException {
        String topic = this.endpoint.getConfiguration().getTopic();
        if (!this.endpoint.getConfiguration().isBridgeEndpoint()) {
            Endpoint from;
            String headerTopic = (String)exchange.getIn().getHeader("kafka.TOPIC", String.class);
            boolean allowHeader = true;
            if (headerTopic != null && this.endpoint.getConfiguration().isCircularTopicDetection() && (from = exchange.getFromEndpoint()) instanceof KafkaEndpoint) {
                String fromTopic = ((KafkaEndpoint)from).getConfiguration().getTopic();
                boolean bl = allowHeader = !headerTopic.equals(fromTopic);
                if (!allowHeader) {
                    this.log.debug("Circular topic detected from message header. Cannot send to same topic as the message comes from: {}. Will use endpoint configured topic: {}", (Object)from, (Object)topic);
                }
            }
            if (allowHeader && headerTopic != null) {
                topic = headerTopic;
            }
        }
        if (topic == null) {
            throw new CamelExchangeException("No topic key set", exchange);
        }
        final Integer partitionKey = this.endpoint.getConfiguration().getPartitionKey() != null ? this.endpoint.getConfiguration().getPartitionKey() : (Integer)exchange.getIn().getHeader("kafka.PARTITION_KEY", Integer.class);
        final boolean hasPartitionKey = partitionKey != null;
        final Object key = this.endpoint.getConfiguration().getKey() != null ? this.endpoint.getConfiguration().getKey() : exchange.getIn().getHeader("kafka.KEY");
        Object messageKey = key != null ? this.tryConvertToSerializedType(exchange, key, this.endpoint.getConfiguration().getKeySerializerClass()) : null;
        final boolean hasMessageKey = messageKey != null;
        Object msg = exchange.getIn().getBody();
        Iterator iterator = null;
        if (msg instanceof Iterable) {
            iterator = ((Iterable)msg).iterator();
        } else if (msg instanceof Iterator) {
            iterator = (Iterator)msg;
        }
        if (iterator != null) {
            final Iterator msgList = iterator;
            final String msgTopic = topic;
            return new Iterator<ProducerRecord>(){

                @Override
                public boolean hasNext() {
                    return msgList.hasNext();
                }

                @Override
                public ProducerRecord next() {
                    Object next = msgList.next();
                    Object value = KafkaProducer.this.tryConvertToSerializedType(exchange, next, KafkaProducer.this.endpoint.getConfiguration().getSerializerClass());
                    if (hasPartitionKey && hasMessageKey) {
                        return new ProducerRecord(msgTopic, partitionKey, key, value);
                    }
                    if (hasMessageKey) {
                        return new ProducerRecord(msgTopic, key, value);
                    }
                    return new ProducerRecord(msgTopic, value);
                }

                @Override
                public void remove() {
                    msgList.remove();
                }
            };
        }
        Object value = this.tryConvertToSerializedType(exchange, msg, this.endpoint.getConfiguration().getSerializerClass());
        ProducerRecord record = hasPartitionKey && hasMessageKey ? new ProducerRecord(topic, partitionKey, key, value) : (hasMessageKey ? new ProducerRecord(topic, key, value) : new ProducerRecord(topic, value));
        return Collections.singletonList(record).iterator();
    }

    public void process(Exchange exchange) throws Exception {
        Iterator<ProducerRecord> c = this.createRecorder(exchange);
        LinkedList<Future> futures = new LinkedList<Future>();
        ArrayList recordMetadatas = new ArrayList();
        if (this.endpoint.getConfiguration().isRecordMetadata()) {
            if (exchange.hasOut()) {
                exchange.getOut().setHeader("org.apache.kafka.clients.producer.RecordMetadata", recordMetadatas);
            } else {
                exchange.getIn().setHeader("org.apache.kafka.clients.producer.RecordMetadata", recordMetadatas);
            }
        }
        while (c.hasNext()) {
            ProducerRecord rec = c.next();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Sending message to topic: {}, partition: {}, key: {}", new Object[]{rec.topic(), rec.partition(), rec.key()});
            }
            futures.add(this.kafkaProducer.send(rec));
        }
        for (Future f : futures) {
            recordMetadatas.add(f.get());
        }
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            Iterator<ProducerRecord> c = this.createRecorder(exchange);
            KafkaProducerCallBack cb = new KafkaProducerCallBack(exchange, callback);
            while (c.hasNext()) {
                cb.increment();
                ProducerRecord rec = c.next();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Sending message to topic: {}, partition: {}, key: {}", new Object[]{rec.topic(), rec.partition(), rec.key()});
                }
                this.kafkaProducer.send(rec, (Callback)cb);
            }
            return cb.allSent();
        }
        catch (Exception ex) {
            exchange.setException((Throwable)ex);
            callback.done(true);
            return true;
        }
    }

    protected Object tryConvertToSerializedType(Exchange exchange, Object object, String serializerClass) {
        byte[] array;
        Object answer = null;
        if ("org.apache.kafka.common.serialization.StringSerializer".equals(serializerClass)) {
            answer = exchange.getContext().getTypeConverter().tryConvertTo(String.class, exchange, object);
        } else if ("org.apache.kafka.common.serialization.ByteArraySerializer".equals(serializerClass)) {
            answer = exchange.getContext().getTypeConverter().tryConvertTo(byte[].class, exchange, object);
        } else if ("org.apache.kafka.common.serialization.ByteBufferSerializer".equals(serializerClass)) {
            answer = exchange.getContext().getTypeConverter().tryConvertTo(ByteBuffer.class, exchange, object);
        } else if ("org.apache.kafka.common.serialization.BytesSerializer".equals(serializerClass) && (array = (byte[])exchange.getContext().getTypeConverter().tryConvertTo(byte[].class, exchange, object)) != null) {
            answer = new Bytes(array);
        }
        return answer != null ? answer : object;
    }

    private final class KafkaProducerCallBack
    implements Callback {
        private final Exchange exchange;
        private final AsyncCallback callback;
        private final AtomicInteger count = new AtomicInteger(1);
        private final List<RecordMetadata> recordMetadatas = new ArrayList<RecordMetadata>();

        KafkaProducerCallBack(Exchange exchange, AsyncCallback callback) {
            this.exchange = exchange;
            this.callback = callback;
            if (KafkaProducer.this.endpoint.getConfiguration().isRecordMetadata()) {
                if (exchange.hasOut()) {
                    exchange.getOut().setHeader("org.apache.kafka.clients.producer.RecordMetadata", this.recordMetadatas);
                } else {
                    exchange.getIn().setHeader("org.apache.kafka.clients.producer.RecordMetadata", this.recordMetadatas);
                }
            }
        }

        void increment() {
            this.count.incrementAndGet();
        }

        boolean allSent() {
            if (this.count.decrementAndGet() == 0) {
                KafkaProducer.this.log.trace("All messages sent, continue routing.");
                this.callback.done(true);
                return true;
            }
            return false;
        }

        public void onCompletion(RecordMetadata recordMetadata, Exception e) {
            if (e != null) {
                this.exchange.setException((Throwable)e);
            }
            this.recordMetadatas.add(recordMetadata);
            if (this.count.decrementAndGet() == 0) {
                KafkaProducer.this.workerPool.submit(new Runnable(){

                    @Override
                    public void run() {
                        KafkaProducer.this.log.trace("All messages sent, continue routing.");
                        KafkaProducerCallBack.this.callback.done(false);
                    }
                });
            }
        }
    }
}

