/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.pagination.Region;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.RegionArea;

public class RegionEnd
extends Region {
    public static final String REGION_CLASS = "end";

    protected RegionEnd(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
        super(parent, propertyList, systemId, line, column);
    }

    protected String getDefaultRegionName() {
        return "xsl-region-end";
    }

    public int getExtent() {
        return this.properties.get("extent").getLength().mvalue();
    }

    public String getName() {
        return "fo:region-end";
    }

    public String getRegionClass() {
        return REGION_CLASS;
    }

    RegionArea makeRegionArea(int allocationRectangleXPosition, int allocationRectangleYPosition, int allocationRectangleWidth, int allocationRectangleHeight) {
        BorderAndPadding bap = this.propMgr.getBorderAndPadding();
        BackgroundProps bProps = this.propMgr.getBackgroundProps();
        int extent = this.properties.get("extent").getLength().mvalue();
        return this.makeRegionArea(allocationRectangleXPosition, allocationRectangleYPosition, allocationRectangleWidth, extent, false, false, 0, 0);
    }

    RegionArea makeRegionArea(int allocationRectangleXPosition, int allocationRectangleYPosition, int allocationRectangleWidth, int allocationRectangleHeight, boolean beforePrecedence, boolean afterPrecedence, int beforeExtent, int afterExtent) {
        int extent = this.properties.get("extent").getLength().mvalue();
        int startY = allocationRectangleYPosition;
        int startH = allocationRectangleHeight;
        if (beforePrecedence) {
            startY -= beforeExtent;
            startH -= beforeExtent;
        }
        if (afterPrecedence) {
            startH -= afterExtent;
        }
        RegionArea area = new RegionArea(allocationRectangleXPosition + allocationRectangleWidth - extent, startY, extent, startH);
        area.setBackground(this.propMgr.getBackgroundProps());
        return area;
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
            return new RegionEnd(parent, propertyList, systemId, line, column);
        }
    }
}

