/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.StringTokenizer;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class SVGUtilities {
    static final String svgNS = "http://www.w3.org/2000/svg";

    public static final Element createClip(Document doc, Element els, String id) {
        Element border = doc.createElementNS(svgNS, "clipPath");
        border.setAttributeNS(null, "id", id);
        border.appendChild(els);
        return border;
    }

    public static final Element createEllipse(Document doc, float cx, float cy, float rx, float ry) {
        Element ellipse = doc.createElementNS(svgNS, "ellipse");
        ellipse.setAttributeNS(null, "cx", String.valueOf(cx));
        ellipse.setAttributeNS(null, "rx", String.valueOf(rx));
        ellipse.setAttributeNS(null, "cy", String.valueOf(cy));
        ellipse.setAttributeNS(null, "ry", String.valueOf(ry));
        return ellipse;
    }

    public static final Element createG(Document doc) {
        Element border = doc.createElementNS(svgNS, "g");
        return border;
    }

    public static final Element createImage(Document doc, String ref, float width, float height) {
        Element border = doc.createElementNS(svgNS, "image");
        border.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", ref);
        border.setAttributeNS(null, "width", String.valueOf(width));
        border.setAttributeNS(null, "height", String.valueOf(height));
        return border;
    }

    public static final Element createLine(Document doc, float x, float y, float x2, float y2) {
        Element ellipse = doc.createElementNS(svgNS, "line");
        ellipse.setAttributeNS(null, "x1", String.valueOf(x));
        ellipse.setAttributeNS(null, "x2", String.valueOf(x2));
        ellipse.setAttributeNS(null, "y1", String.valueOf(y));
        ellipse.setAttributeNS(null, "y2", String.valueOf(y2));
        return ellipse;
    }

    public static final Element createPath(Document doc, String str) {
        Element path = doc.createElementNS(svgNS, "path");
        path.setAttributeNS(null, "d", str);
        return path;
    }

    public static final Element createRect(Document doc, float x, float y, float width, float height) {
        Element border = doc.createElementNS(svgNS, "rect");
        border.setAttributeNS(null, "x", String.valueOf(x));
        border.setAttributeNS(null, "y", String.valueOf(y));
        border.setAttributeNS(null, "width", String.valueOf(width));
        border.setAttributeNS(null, "height", String.valueOf(height));
        return border;
    }

    public static final Document createSVGDocument(float width, float height) {
        DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
        Document doc = impl.createDocument(svgNS, "svg", null);
        Element svgRoot = doc.getDocumentElement();
        svgRoot.setAttributeNS(null, "width", String.valueOf(width));
        svgRoot.setAttributeNS(null, "height", String.valueOf(height));
        return doc;
    }

    public static final Element createText(Document doc, float x, float y, String str) {
        Element textGraph = doc.createElementNS(svgNS, "text");
        textGraph.setAttributeNS(null, "x", String.valueOf(x));
        textGraph.setAttributeNS(null, "y", String.valueOf(y));
        Text text = doc.createTextNode(str);
        textGraph.appendChild(text);
        return textGraph;
    }

    public static final Rectangle2D getStringBounds(String str, Font font) {
        return font.getStringBounds(str, 0, str.length(), new FontRenderContext(new AffineTransform(), true, true));
    }

    public static final float getStringHeight(String str, Font font) {
        Rectangle2D rect = font.getStringBounds(str, 0, str.length(), new FontRenderContext(new AffineTransform(), true, true));
        return (float)rect.getHeight();
    }

    public static final float getStringWidth(String str, Font font) {
        Rectangle2D rect = font.getStringBounds(str, 0, str.length(), new FontRenderContext(new AffineTransform(), true, true));
        return (float)rect.getWidth();
    }

    public static final Element wrapText(Document doc, String str, Font font, float width) {
        Element g = SVGUtilities.createG(doc);
        StringTokenizer st = new StringTokenizer(str, " \t\r\n");
        float totalWidth = 0.0f;
        String totalStr = "";
        int line = 0;
        float height = SVGUtilities.getStringHeight(str, font);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            float strwidth = SVGUtilities.getStringWidth(token, font);
            if ((totalWidth += strwidth) > width) {
                if (totalStr.equals("")) {
                    totalStr = token;
                    token = "";
                    strwidth = 0.0f;
                }
                Element text = SVGUtilities.createText(doc, 0.0f, (float)line * (height + 5.0f), totalStr);
                g.appendChild(text);
                totalStr = token;
                totalWidth = strwidth;
                ++line;
                continue;
            }
            totalStr = String.valueOf(totalStr) + " " + token;
        }
        return g;
    }
}

