/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg12;

import java.net.URL;
import org.apache.batik.css.engine.CSSContext;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.SVG12CSSEngine;
import org.apache.batik.css.engine.value.ShorthandManager;
import org.apache.batik.css.engine.value.ValueManager;
import org.apache.batik.css.parser.ExtendedParser;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.AbstractStylableDocument;
import org.apache.batik.dom.ExtensibleDOMImplementation;
import org.apache.batik.dom.GenericElement;
import org.apache.batik.dom.GenericElementNS;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.svg12.SVGOMFlowDivElement;
import org.apache.batik.dom.svg12.SVGOMFlowLineElement;
import org.apache.batik.dom.svg12.SVGOMFlowParaElement;
import org.apache.batik.dom.svg12.SVGOMFlowRegionBreakElement;
import org.apache.batik.dom.svg12.SVGOMFlowRegionElement;
import org.apache.batik.dom.svg12.SVGOMFlowRegionExcludeElement;
import org.apache.batik.dom.svg12.SVGOMFlowRootElement;
import org.apache.batik.dom.svg12.SVGOMFlowSpanElement;
import org.apache.batik.dom.svg12.SVGOMMultiImageElement;
import org.apache.batik.dom.svg12.SVGOMSolidColorElement;
import org.apache.batik.dom.svg12.SVGOMSubImageElement;
import org.apache.batik.dom.svg12.SVGOMSubImageRefElement;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.dom.util.HashTable;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

public class SVG12DOMImplementation
extends SVGDOMImplementation {
    protected static HashTable svg12Factories = new HashTable(svg11Factories);
    protected static final DOMImplementation DOM_IMPLEMENTATION;

    public SVG12DOMImplementation() {
        this.factories = svg12Factories;
        this.registerFeature("CSS", "2.0");
        this.registerFeature("StyleSheets", "2.0");
        this.registerFeature("SVG", new String[]{"1.0", "1.1", "1.2"});
        this.registerFeature("SVGEvents", new String[]{"1.0", "1.1", "1.2"});
    }

    public CSSEngine createCSSEngine(AbstractStylableDocument abstractStylableDocument, CSSContext cSSContext, ExtendedParser extendedParser, ValueManager[] valueManagerArray, ShorthandManager[] shorthandManagerArray) {
        URL uRL = ((SVGOMDocument)abstractStylableDocument).getURLObject();
        SVG12CSSEngine sVG12CSSEngine = new SVG12CSSEngine(abstractStylableDocument, uRL, extendedParser, valueManagerArray, shorthandManagerArray, cSSContext);
        URL uRL2 = this.getClass().getResource("resources/UserAgentStyleSheet.css");
        if (uRL2 != null) {
            InputSource inputSource = new InputSource(uRL2.toString());
            sVG12CSSEngine.setUserAgentStyleSheet(sVG12CSSEngine.parseStyleSheet(inputSource, uRL2, "all"));
        }
        return sVG12CSSEngine;
    }

    public Document createDocument(String string, String string2, DocumentType documentType) throws DOMException {
        SVGOMDocument sVGOMDocument = new SVGOMDocument(documentType, this);
        if (string2 != null) {
            sVGOMDocument.appendChild(sVGOMDocument.createElementNS(string, string2));
        }
        return sVGOMDocument;
    }

    public Element createElementNS(AbstractDocument abstractDocument, String string, String string2) {
        String string3;
        ExtensibleDOMImplementation.ElementFactory elementFactory;
        if (string == null) {
            return new GenericElement(string2.intern(), abstractDocument);
        }
        if ("http://www.w3.org/2000/svg".equals(string) && (elementFactory = (ExtensibleDOMImplementation.ElementFactory)this.factories.get(string3 = DOMUtilities.getLocalName(string2))) != null) {
            return elementFactory.create(DOMUtilities.getPrefix(string2), abstractDocument);
        }
        return new GenericElementNS(string.intern(), string2.intern(), abstractDocument);
    }

    public static DOMImplementation getDOMImplementation() {
        return DOM_IMPLEMENTATION;
    }

    static {
        svg12Factories.put("flowDiv", new FlowDivElementFactory());
        svg12Factories.put("flowLine", new FlowLineElementFactory());
        svg12Factories.put("flowPara", new FlowParaElementFactory());
        svg12Factories.put("flowRegionBreak", new FlowRegionBreakElementFactory());
        svg12Factories.put("flowRegion", new FlowRegionElementFactory());
        svg12Factories.put("flowRegionExclude", new FlowRegionExcludeElementFactory());
        svg12Factories.put("flowRoot", new FlowRootElementFactory());
        svg12Factories.put("flowSpan", new FlowSpanElementFactory());
        svg12Factories.put("multiImage", new MultiImageElementFactory());
        svg12Factories.put("solidColor", new SolidColorElementFactory());
        svg12Factories.put("subImage", new SubImageElementFactory());
        svg12Factories.put("subImageRef", new SubImageRefElementFactory());
        DOM_IMPLEMENTATION = new SVG12DOMImplementation();
    }

    protected static class SubImageRefElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMSubImageRefElement(string, (AbstractDocument)document);
        }
    }

    protected static class SubImageElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMSubImageElement(string, (AbstractDocument)document);
        }
    }

    protected static class SolidColorElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMSolidColorElement(string, (AbstractDocument)document);
        }
    }

    protected static class MultiImageElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMMultiImageElement(string, (AbstractDocument)document);
        }
    }

    protected static class FlowSpanElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMFlowSpanElement(string, (AbstractDocument)document);
        }
    }

    protected static class FlowRootElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMFlowRootElement(string, (AbstractDocument)document);
        }
    }

    protected static class FlowRegionExcludeElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMFlowRegionExcludeElement(string, (AbstractDocument)document);
        }
    }

    protected static class FlowRegionElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMFlowRegionElement(string, (AbstractDocument)document);
        }
    }

    protected static class FlowRegionBreakElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMFlowRegionBreakElement(string, (AbstractDocument)document);
        }
    }

    protected static class FlowParaElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMFlowParaElement(string, (AbstractDocument)document);
        }
    }

    protected static class FlowLineElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMFlowLineElement(string, (AbstractDocument)document);
        }
    }

    protected static class FlowDivElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMFlowDivElement(string, (AbstractDocument)document);
        }
    }
}

