/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form.upload;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.fileupload2.core.FileItem;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.model.IModel;
import org.apache.wicket.protocol.http.IMultipartWebRequest;
import org.apache.wicket.request.Request;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.string.Strings;

public class FileUploadField
extends FormComponent<List<FileUpload>> {
    private static final long serialVersionUID = 1L;
    private transient List<FileUpload> fileUploads;

    public FileUploadField(String id) {
        super(id);
    }

    public FileUploadField(String id, IModel<? extends List<FileUpload>> model) {
        super(id, model);
    }

    public FileUpload getFileUpload() {
        List<FileUpload> fileUploads = this.getFileUploads();
        return fileUploads.isEmpty() ? null : fileUploads.get(0);
    }

    public List<FileUpload> getFileUploads() {
        List<FileItem> fileItems;
        if (this.fileUploads != null) {
            return this.fileUploads;
        }
        this.fileUploads = new ArrayList<FileUpload>();
        Request request = this.getRequest();
        if (request instanceof IMultipartWebRequest && (fileItems = ((IMultipartWebRequest)request).getFile(this.getInputName())) != null) {
            for (FileItem item : fileItems) {
                if (Strings.isEmpty((String)item.getName())) continue;
                this.fileUploads.add(new FileUpload(item));
            }
        }
        return this.fileUploads;
    }

    @Override
    public void updateModel() {
        if (this.getModel() != null) {
            super.updateModel();
        }
    }

    @Override
    public String[] getInputAsArray() {
        List<FileUpload> fileUploads = this.getFileUploads();
        if (!fileUploads.isEmpty()) {
            ArrayList<String> clientFileNames = new ArrayList<String>();
            for (FileUpload fu : fileUploads) {
                clientFileNames.add(fu.getClientFileName());
            }
            return clientFileNames.toArray(new String[clientFileNames.size()]);
        }
        return null;
    }

    @Override
    protected List<FileUpload> convertValue(String[] value) throws ConversionException {
        String[] filenames = this.getInputAsArray();
        if (filenames == null) {
            return null;
        }
        return this.getFileUploads();
    }

    @Override
    public boolean isMultiPart() {
        return true;
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        this.checkComponentTag(tag, "input");
        this.checkComponentTagAttribute(tag, "type", "file");
        super.onComponentTag(tag);
    }

    @Override
    protected void onDetach() {
        if (this.fileUploads != null) {
            if (this.forceCloseStreamsOnDetach()) {
                for (FileUpload fu : this.fileUploads) {
                    fu.closeStreams();
                }
                if (this.getModel() != null) {
                    this.getModel().setObject(null);
                }
            }
            this.fileUploads = null;
        }
        super.onDetach();
    }

    protected boolean forceCloseStreamsOnDetach() {
        return true;
    }
}

