/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html;

import java.io.File;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.wicket.Application;
import org.apache.wicket.markup.html.IPackageResourceGuard;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageResourceGuard
implements IPackageResourceGuard {
    private static final Logger log = LoggerFactory.getLogger(PackageResourceGuard.class);
    private Set<String> blockedExtensions = new HashSet<String>(4);
    private Set<String> blockedFiles = new HashSet<String>(4);
    private boolean allowAccessToRootResources = false;

    public PackageResourceGuard() {
        this.blockedExtensions.add("properties");
        this.blockedExtensions.add("class");
        this.blockedExtensions.add("java");
        this.blockedFiles.add("applicationContext.xml");
        this.blockedFiles.add("log4j.xml");
    }

    @Override
    public boolean accept(String path) {
        int ixExtension = path.lastIndexOf(46);
        int len = path.length();
        String ext = ixExtension <= 0 || ixExtension == len || path.lastIndexOf(47) + 1 == ixExtension || path.lastIndexOf(92) + 1 == ixExtension ? null : path.substring(ixExtension + 1).toLowerCase(Locale.ROOT).trim();
        if ("html".equals(ext)) {
            String prefix = path.substring(0, ixExtension);
            ClassLoader classLoader = this.getClass().getClassLoader();
            while (true) {
                if (classLoader.getResource(prefix + ".class") != null) {
                    log.warn("Access denied to shared (static) resource because it is a Wicket markup file: " + path);
                    return false;
                }
                int ixUnderscore = prefix.lastIndexOf(95);
                if (ixUnderscore == -1) break;
                prefix = prefix.substring(0, ixUnderscore);
            }
        }
        if (!this.acceptExtension(ext)) {
            log.warn("Access denied to shared (static) resource because of the file extension: " + path);
            return false;
        }
        String filename = Strings.lastPathComponent(path, File.separatorChar);
        if (!this.acceptFile(filename)) {
            log.warn("Access denied to shared (static) resource because of the file name: " + path);
            return false;
        }
        if (Strings.isEmpty(Application.get().getResourceSettings().getParentFolderPlaceholder()) && path.contains("..")) {
            log.warn("Access to parent directories via '..' is by default disabled for shared resources: " + path);
            return false;
        }
        if (!this.allowAccessToRootResources) {
            String absolute = path;
            if ("\\".equals(File.separator)) {
                int drive = absolute.indexOf(":\\");
                if (drive < 0) {
                    drive = absolute.indexOf(":/");
                }
                if (drive > 0) {
                    absolute = absolute.substring(drive + 2);
                }
            }
            if (absolute.startsWith(File.separator) || absolute.startsWith("/")) {
                absolute = absolute.substring(1);
            }
            if (!absolute.contains(File.separator) && !absolute.contains("/")) {
                log.warn("Access to root directory is by default disabled for shared resources: " + path);
                return false;
            }
        }
        return true;
    }

    protected boolean acceptExtension(String extension) {
        return !this.blockedExtensions.contains(extension);
    }

    protected boolean acceptFile(String file) {
        if (file != null) {
            file = file.trim();
        }
        return !this.blockedFiles.contains(file);
    }

    protected final Set<String> getBlockedExtensions() {
        return this.blockedExtensions;
    }

    protected final Set<String> getBlockedFiles() {
        return this.blockedFiles;
    }

    protected final void setBlockedExtensions(Set<String> blockedExtensions) {
        this.blockedExtensions = blockedExtensions;
    }

    protected final void setBlockedFiles(Set<String> blockedFiles) {
        this.blockedFiles = blockedFiles;
    }

    public final boolean isAllowAccessToRootResources() {
        return this.allowAccessToRootResources;
    }

    public final void setAllowAccessToRootResources(boolean allowAccessToRootResources) {
        this.allowAccessToRootResources = allowAccessToRootResources;
    }
}

