
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2004 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level3.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 *  The method isId returns whether this attribute is known to be of type ID or not.
 *  
 *  Add a new attribute of type ID to the third acronym element node of this document. Verify that the method
 *         isId returns true. The use of Element.setIdAttributeNS() makes 'isId' a user-determined ID attribute.
 *  Import the newly created attribute node into this document.  
 *         Since user data assocated to the imported node is not carried over, verify that the method isId
 *         returns false on the imported attribute node.        
* @author IBM
* @author Neil Delima
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#Attr-isId">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#Attr-isId</a>
*/
public final class attrisid07 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public attrisid07(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {

      org.w3c.domts.DocumentBuilderSetting[] settings = 
          new org.w3c.domts.DocumentBuilderSetting[] {
org.w3c.domts.DocumentBuilderSetting.namespaceAware
        };
        DOMTestDocumentBuilderFactory testFactory = factory.newInstance(settings);
        setFactory(testFactory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "hc_staff", false);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      NodeList elemList;
      Element acronymElem;
      NamedNodeMap attributesMap;
      Attr attr;
      Attr attrImported;
      boolean id = false;
      Element elem;
      String elemName;
      doc = (Document) load("hc_staff", false);
      elemList = doc.getElementsByTagNameNS("*", "acronym");
      acronymElem = (Element) elemList.item(2);
      acronymElem.setAttributeNS("http://www.w3.org/DOM", "dom3:newAttr", "null");
      acronymElem.setIdAttributeNS("http://www.w3.org/DOM", "newAttr", true);
      attr = acronymElem.getAttributeNodeNS("http://www.w3.org/DOM", "newAttr");
      id = attr.isId();
      assertTrue("AttrIsIDTrue07_1", id);
      attrImported = (Attr) doc.importNode(attr, false);
      id = attrImported.isId();
      assertFalse("AttrIsID07_isFalseforImportedNode", id);
}
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/attrisid07";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(attrisid07.class, args);
   }
}

