/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.File;
import java.util.Date;
import java.util.Vector;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;

public class SourceFileScanner {
    protected Task task;
    private FileUtils fileUtils;

    public SourceFileScanner(Task task) {
        this.task = task;
        this.fileUtils = FileUtils.newFileUtils();
    }

    public String[] restrict(String[] files, File srcDir, File destDir, FileNameMapper mapper) {
        long now = new Date().getTime();
        StringBuffer targetList = new StringBuffer();
        if (Os.isFamily("windows")) {
            now += 2000L;
        }
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (i < files.length) {
            String[] targets = mapper.mapFileName(files[i]);
            if (targets == null || targets.length == 0) {
                this.task.log(files[i] + " skipped - don't know how to handle it", 3);
            } else {
                File src = this.fileUtils.resolveFile(srcDir, files[i]);
                if (src.lastModified() > now) {
                    this.task.log("Warning: " + files[i] + " modified in the future.", 1);
                }
                boolean added = false;
                targetList.setLength(0);
                int j = 0;
                while (!added && j < targets.length) {
                    File dest = this.fileUtils.resolveFile(destDir, targets[j]);
                    if (!dest.exists()) {
                        this.task.log(files[i] + " added as " + dest.getAbsolutePath() + " doesn't exist.", 3);
                        v.addElement(files[i]);
                        added = true;
                    } else if (src.lastModified() > dest.lastModified()) {
                        this.task.log(files[i] + " added as " + dest.getAbsolutePath() + " is outdated.", 3);
                        v.addElement(files[i]);
                        added = true;
                    } else {
                        if (targetList.length() > 0) {
                            targetList.append(", ");
                        }
                        targetList.append(dest.getAbsolutePath());
                    }
                    ++j;
                }
                if (!added) {
                    this.task.log(files[i] + " omitted as " + targetList.toString() + (targets.length == 1 ? " is" : " are ") + " up to date.", 3);
                }
            }
            ++i;
        }
        Object[] result = new String[v.size()];
        v.copyInto(result);
        return result;
    }

    public File[] restrictAsFiles(String[] files, File srcDir, File destDir, FileNameMapper mapper) {
        String[] res = this.restrict(files, srcDir, destDir, mapper);
        File[] result = new File[res.length];
        int i = 0;
        while (i < res.length) {
            result[i] = new File(srcDir, res[i]);
            ++i;
        }
        return result;
    }
}

