/*
 * DebugTemplate.java
 *
 * Brazil project web application toolkit,
 * export version: 2.1 
 * Copyright (c) 2000-2003 Sun Microsystems, Inc.
 *
 * Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License Version 
 * 1.0 (the "License"). You may not use this file except in compliance with 
 * the License. A copy of the License is included as the file "license.terms",
 * and also available at http://www.sun.com/
 * 
 * The Original Code is from:
 *    Brazil project web application toolkit release 2.1.
 * The Initial Developer of the Original Code is: suhler.
 * Portions created by suhler are Copyright (C) Sun Microsystems, Inc.
 * All Rights Reserved.
 * 
 * Contributor(s): suhler.
 *
 * Version:  2.3
 * Created by suhler on 00/11/17
 * Last modified by suhler on 03/07/15 09:11:19
 */

package sunlabs.brazil.template;

import sunlabs.brazil.util.Format;
import java.io.Serializable;

/**
 * Template class for printing stuff to stderr (for template debugging).
 * This class is used by the TemplateHandler.
 * <p>
 * A new HTML tag,  
 * <code>&lt;debug&gt;</code> is defined.  Any text between the
 * <code>&lt;debug</code> and <code>&gt;</code> is printed on stderr,
 *  along with the
 * session id and the url.  Variable substitutions of the form
 * ${...} are performed on the text.
 * <p>
 * The property <code>debug</code> must be present for this template
 * to function.  Otherwise, all <code>debug</code> tags are removed.
 * <dl class=props>
 * <dt><code>debug</code>
 * <dd> If this configuration parameter is true, debugging is enabled.
 * </dl>
 *
 * @author		Stephen Uhler
 * @version		%V% 04/04/05
 */

public class DebugTemplate extends Template implements Serializable {
    private static final String DEBUG = "debug";
    transient boolean debug;

    public boolean
    init(RewriteContext hr) {
	String dbg = hr.request.props.getProperty(hr.prefix + DEBUG);
	debug = Format.isTrue(dbg);
	return true;
    }

    public void
    tag_debug(RewriteContext hr)
    {
	if (debug) {
	    String stuff = hr.getArgs();
	    if (stuff != null) {
		String map = Format.subst(hr.request.props, stuff);
		System.err.println("Debug " + hr.sessionId + ":" +
		      hr.request.url + " " + map);
		hr.append("\n<!--DEBUG " + stuff + "\n    " + map + "-->\n");
	    }
	}
	hr.killToken();
    }
}
