/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.NormalizerImpl;
import com.ibm.icu.impl.USerializedSet;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.UTF16;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class CanonicalIterator {
    private static boolean PROGRESS = false;
    private static boolean SKIP_ZEROS = true;
    private String source;
    private boolean done;
    private String[][] pieces;
    private int[] current;
    private transient StringBuffer buffer = new StringBuffer();
    private static final Set SET_WITH_NULL_STRING = new HashSet();

    public CanonicalIterator(String source) {
        this.setSource(source);
    }

    public String getSource() {
        return this.source;
    }

    public void reset() {
        this.done = false;
        int i = 0;
        while (i < this.current.length) {
            this.current[i] = 0;
            ++i;
        }
    }

    public String next() {
        if (this.done) {
            return null;
        }
        this.buffer.setLength(0);
        int i = 0;
        while (i < this.pieces.length) {
            this.buffer.append(this.pieces[i][this.current[i]]);
            ++i;
        }
        String result = this.buffer.toString();
        int i2 = this.current.length - 1;
        while (true) {
            if (i2 < 0) {
                this.done = true;
                break;
            }
            int n = i2;
            this.current[n] = this.current[n] + 1;
            if (this.current[i2] < this.pieces[i2].length) break;
            this.current[i2] = 0;
            --i2;
        }
        return result;
    }

    public void setSource(String newSource) {
        this.source = Normalizer.normalize(newSource, Normalizer.NFD);
        this.done = false;
        if (newSource.length() == 0) {
            this.pieces = new String[1][];
            this.current = new int[1];
            this.pieces[0] = new String[]{""};
            return;
        }
        ArrayList<String> segmentList = new ArrayList<String>();
        int start = 0;
        int i = UTF16.findOffsetFromCodePoint(this.source, 1);
        while (i < this.source.length()) {
            int cp = UTF16.charAt(this.source, i);
            if (NormalizerImpl.isCanonSafeStart(cp)) {
                segmentList.add(this.source.substring(start, i));
                start = i;
            }
            i += UTF16.getCharCount(cp);
        }
        segmentList.add(this.source.substring(start, i));
        this.pieces = new String[segmentList.size()][];
        this.current = new int[segmentList.size()];
        i = 0;
        while (i < this.pieces.length) {
            if (PROGRESS) {
                System.out.println("SEGMENT");
            }
            this.pieces[i] = this.getEquivalents((String)segmentList.get(i));
            ++i;
        }
    }

    public static void permute(String source, boolean skipZeros, Set output) {
        if (source.length() <= 2 && UTF16.countCodePoint(source) <= 1) {
            output.add(source);
            return;
        }
        HashSet subpermute = new HashSet();
        int i = 0;
        while (i < source.length()) {
            int cp = UTF16.charAt(source, i);
            if (!skipZeros || i == 0 || UCharacter.getCombiningClass(cp) != 0) {
                subpermute.clear();
                CanonicalIterator.permute(source.substring(0, i) + source.substring(i + UTF16.getCharCount(cp)), skipZeros, subpermute);
                String chStr = UTF16.valueOf(source, i);
                Iterator it = subpermute.iterator();
                while (it.hasNext()) {
                    String piece = chStr + (String)it.next();
                    output.add(piece);
                }
            }
            i += UTF16.getCharCount(cp);
        }
    }

    private String[] getEquivalents(String segment) {
        HashSet<String> result = new HashSet<String>();
        Set basic = this.getEquivalents2(segment);
        HashSet permutations = new HashSet();
        Iterator it = basic.iterator();
        while (it.hasNext()) {
            String item = (String)it.next();
            permutations.clear();
            CanonicalIterator.permute(item, SKIP_ZEROS, permutations);
            Iterator it2 = permutations.iterator();
            while (it2.hasNext()) {
                String possible = (String)it2.next();
                if (Normalizer.compare(possible, segment, 0) == 0) {
                    if (PROGRESS) {
                        System.out.println("Adding Permutation: " + Utility.hex(possible));
                    }
                    result.add(possible);
                    continue;
                }
                if (!PROGRESS) continue;
                System.out.println("-Skipping Permutation: " + Utility.hex(possible));
            }
        }
        String[] finalResult = new String[result.size()];
        result.toArray(finalResult);
        return finalResult;
    }

    private Set getEquivalents2(String segment) {
        HashSet<String> result = new HashSet<String>();
        if (PROGRESS) {
            System.out.println("Adding: " + Utility.hex(segment));
        }
        result.add(segment);
        StringBuffer workingBuffer = new StringBuffer();
        int cp = 0;
        int[] range = new int[2];
        int i = 0;
        while (i < segment.length()) {
            USerializedSet starts;
            cp = UTF16.charAt(segment, i);
            if (NormalizerImpl.getCanonStartSet(cp, starts = new USerializedSet())) {
                int j = 0;
                int rangeCount = starts.countRanges();
                j = 0;
                while (j < rangeCount) {
                    starts.getRange(j, range);
                    int end = range[1];
                    int cp2 = range[0];
                    while (cp2 <= end) {
                        Set remainder = this.extract(cp2, segment, i, workingBuffer);
                        if (remainder != null) {
                            String prefix = segment.substring(0, i);
                            prefix = prefix + UTF16.valueOf(cp2);
                            Iterator iter = remainder.iterator();
                            while (iter.hasNext()) {
                                String item = (String)iter.next();
                                String toAdd = new String(prefix);
                                toAdd = toAdd + item;
                                result.add(toAdd);
                            }
                        }
                        ++cp2;
                    }
                    ++j;
                }
            }
            i += UTF16.getCharCount(cp);
        }
        return result;
    }

    private Set extract(int comp, String segment, int segmentPos, StringBuffer buf) {
        if (PROGRESS) {
            System.out.println(" extract: " + Utility.hex(UTF16.valueOf(comp)) + ", " + Utility.hex(segment.substring(segmentPos)));
        }
        String decomp = Normalizer.normalize(comp, Normalizer.NFD);
        boolean ok = false;
        int decompPos = 0;
        int decompCp = UTF16.charAt(decomp, 0);
        decompPos += UTF16.getCharCount(decompCp);
        buf.setLength(0);
        int i = segmentPos;
        while (i < segment.length()) {
            int cp = UTF16.charAt(segment, i);
            if (cp == decompCp) {
                if (PROGRESS) {
                    System.out.println("  matches: " + Utility.hex(UTF16.valueOf(cp)));
                }
                if (decompPos == decomp.length()) {
                    buf.append(segment.substring(i + UTF16.getCharCount(cp)));
                    ok = true;
                    break;
                }
                decompCp = UTF16.charAt(decomp, decompPos);
                decompPos += UTF16.getCharCount(decompCp);
            } else {
                if (PROGRESS) {
                    System.out.println("  buffer: " + Utility.hex(UTF16.valueOf(cp)));
                }
                UTF16.append(buf, cp);
            }
            i += UTF16.getCharCount(cp);
        }
        if (!ok) {
            return null;
        }
        if (PROGRESS) {
            System.out.println("Matches");
        }
        if (buf.length() == 0) {
            return SET_WITH_NULL_STRING;
        }
        String remainder = buf.toString();
        if (0 != Normalizer.compare(UTF16.valueOf(comp) + remainder, segment.substring(segmentPos), 0)) {
            return null;
        }
        return this.getEquivalents2(remainder);
    }

    static {
        SET_WITH_NULL_STRING.add("");
    }
}

