/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.test;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.batik.test.AbstractTest;
import org.apache.batik.test.DefaultTestSuiteReport;
import org.apache.batik.test.Test;
import org.apache.batik.test.TestReport;
import org.apache.batik.test.TestSuite;

public class DefaultTestSuite
extends AbstractTest
implements TestSuite {
    private String name = null;
    protected List tests = new ArrayList();

    @Override
    public void addTest(Test test) {
        if (test == null) {
            throw new IllegalArgumentException();
        }
        test.setParent(this);
        this.tests.add(test);
    }

    @Override
    public void removeTest(Test test) {
        this.tests.remove(test);
    }

    @Override
    public TestReport runImpl() {
        Iterator iter = this.tests.iterator();
        DefaultTestSuiteReport report = new DefaultTestSuiteReport(this);
        while (iter.hasNext()) {
            Test t = (Test)iter.next();
            System.err.println("Running " + t.getName());
            TestReport tr = t.run();
            if (tr == null) {
                System.out.println("ERROR" + t.getId() + " returned a null report");
            }
            report.addReport(tr);
        }
        return report;
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        String id = this.getId();
        if (id != null && !"".equals(id)) {
            return id;
        }
        return this.getClass().getName();
    }

    @Override
    public void setName(String name) {
        if (name == null && !"".equals(name)) {
            throw new IllegalArgumentException();
        }
        this.name = name;
    }

    @Override
    public Test[] getChildrenTests() {
        Test[] children = new Test[this.tests.size()];
        this.tests.toArray(children);
        return children;
    }

    @Override
    public int getChildrenCount() {
        return this.tests.size();
    }
}

