unit module Transit::Network::Helpers:ver<0.0.4>;

our sub dehourify ($string is copy) is export # E.g. "1h30" -> "90".
{
  return $string unless $string ~~ /<[dh]>/;

  my $min = 0;

  if $string ~~ /^(\d+)d(.*)/
  {
    $min    = $0 * 60 * 24;
    $string = $1.Str;
  }

  if $string ~~ /^(\d+)h(.*)/
  {
    $min   += $0 * 60;
    $string = $1.Str;
  }

  $min += $string;

  return $min;
}

sub dehourify-interval($interval) is export
{
  return $interval.split(";").map({ dehourify($_) }).join(';');
}

sub min2dep ($string) is export
{
  my @depts = $string.split(/\s+/);

  return @depts.map({ $_.chars == 2 ?? "00$_" !! "00$_.substr(0,2).5" });
}

sub dep-add (@depts, $add) is export
{
  my @return;
  for @depts -> $current
  {
    my $new = $current + $add;
    @return.push: $new ~~ /\.5^/ ?? ( "0" x (6 - $new.chars) ~ $new ) !! ("0" x (4 - $new.chars) ~ $new  );
  }

  return @return;
}

sub nice-time ($time is copy, :$days) is export
{
  my $half = " ";
  
  if $time ~~ /(\d+)\.5$/
  {
    $time = $0;
    $half = "'";
  }

  my ($min, $hour) = $time.Int.polymod(60);

  if $days
  {
    my $day = $hour div 24;
    $hour   = $hour - $day * 24;

    $day == 0
      ?? return "  { $hour.fmt('%02d') }{ $min.fmt('%02d') }{ $half }"
      !! return "{$day}+{ $hour.fmt('%02d') }{ $min.fmt('%02d') }{ $half }";
  }

  return "{ $hour.fmt('%02d') }{ $min.fmt('%02d') }{ $half }";
}

sub multi-lines (*@lines is copy) is export
{
  my @out;
  my $current = @lines.shift;

  while (@lines)
  {
    while $current ~~ /(.*)\\$/
    {
      $current = $0 ~ @lines.shift;
    }
    
    @out.push: $current;
    $current = @lines.shift;
  }
  
  @out.push: $current if $current;
   
  return @out;
}

sub print-time ($min is copy, $interval = 0) is export
{
  $min -= 60 while $min >= 60;

  unless $interval
  {
    return $min ~~ /\.5$/ ?? $min.fmt('%02d\'') !! $min.fmt('%02d') ~ ' '; 
  }

  my @interval = $interval.split(";");
  my $index    = 0;
  my @times    = $min ~~ /\.5$/ ?? $min.fmt('%02d\'') !! $min.fmt('%02d') ~ ' ';
  my $curr     = $min + @interval[$index++ % @interval.elems];
  
  $curr -= 60 if $curr >= 60;

  while $curr != $min
  {
    @times.push: $curr ~~ /\.5$/ ?? $curr.fmt('%02d\'') !! $curr.fmt('%02d') ~ ' ';

    $curr += @interval[$index++ % @interval.elems];
    $curr -= 60 if $curr >= 60;
  }

  return @times.join(' ');
}

sub print-time-hour ($min is copy, $interval = 0) is export
{
  return h-time($min) unless $interval;

  my @interval = $interval.split(";");
  my $index    = 0;
  my @times    = h-time($min);
  my $curr     = $min + @interval[$index++ % @interval.elems];
  
  while $curr % 60 != $min
  {
    @times.push: h-time($curr); #  ~~ /\.5$/ ?? $curr.fmt('%02d\'') !! $curr.fmt('%02d') ~ ' ';

    $curr += @interval[$index++ % @interval.elems];
  }

  return @times.join(' ');
}

sub h-time ($min) is export
{
  my $half  = $min ~~ /\.5$/ ?? "'" !! " ";
  my $mins  = $min.Int;
  
  my $hours = $mins div 60;
  my $mins2 = $mins - $hours * 60;

  return "{ $hours }h{ $mins2.fmt('%02d') }{ $half }";
}