=begin comment

Copyright (c) 2019 Aspose Pty Ltd

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

=end comment

=cut

package AsposeSlidesCloud::Object::Document;

require 5.6.0;
use strict;
use warnings;
use utf8;
use JSON qw(decode_json);
use Data::Dumper;
use Module::Runtime qw(use_module);
use Log::Any qw($log);
use Date::Parse;
use DateTime;

use AsposeSlidesCloud::Object::ResourceBase;
use AsposeSlidesCloud::Object::ResourceUri;

use base ("Class::Accessor", "Class::Data::Inheritable");


#
#Represents document DTO.
#
# NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
# REF: https://github.com/swagger-api/swagger-codegen
#

#
# NOTE: This class is auto generated by the swagger code generator program. 
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
__PACKAGE__->mk_classdata('attribute_map' => {});
__PACKAGE__->mk_classdata('swagger_types' => {});
__PACKAGE__->mk_classdata('method_documentation' => {}); 
__PACKAGE__->mk_classdata('class_documentation' => {});

# new object
sub new { 
    my ($class, %args) = @_; 

	my $self = bless {}, $class;
	
	foreach my $attribute (keys %{$class->attribute_map}) {
		my $args_key = $class->attribute_map->{$attribute};
		$self->$attribute( $args{ $args_key } );
	}
	return $self;
}  

# used by JSON for serialization
sub TO_JSON { 
    my $self = shift;
    my $_data = {};
    foreach my $_key (keys %{$self->attribute_map}) {
        if (defined $self->{$_key}) {
            $_data->{$self->attribute_map->{$_key}} = $self->{$_key};
        }
    }
    return $_data;
}


__PACKAGE__->class_documentation({description => 'Represents document DTO.',
                                  class => 'Document',
                                  required => [], # TODO
}                                 );

__PACKAGE__->method_documentation({
    'self_uri' => {
    	datatype => 'ResourceUri',
    	base_name => 'SelfUri',
    	description => 'Gets or sets the link to this resource.',
    	format => '',
    	read_only => '',
    		},
    'alternate_links' => {
    	datatype => 'ARRAY[ResourceUri]',
    	base_name => 'AlternateLinks',
    	description => 'List of alternate links.',
    	format => '',
    	read_only => '',
    		},
    'document_properties' => {
    	datatype => 'ResourceUri',
    	base_name => 'DocumentProperties',
    	description => 'Link to Document properties.',
    	format => '',
    	read_only => '',
    		},
    'view_properties' => {
    	datatype => 'ResourceUri',
    	base_name => 'ViewProperties',
    	description => 'Link to Document properties.',
    	format => '',
    	read_only => '',
    		},
    'slides' => {
    	datatype => 'ResourceUri',
    	base_name => 'Slides',
    	description => 'Link to slides collection.',
    	format => '',
    	read_only => '',
    		},
    'images' => {
    	datatype => 'ResourceUri',
    	base_name => 'Images',
    	description => 'Link to images collection.',
    	format => '',
    	read_only => '',
    		},
    'layout_slides' => {
    	datatype => 'ResourceUri',
    	base_name => 'LayoutSlides',
    	description => 'Link to layout slides collection.',
    	format => '',
    	read_only => '',
    		},
    'master_slides' => {
    	datatype => 'ResourceUri',
    	base_name => 'MasterSlides',
    	description => 'Link to master slides collection.',
    	format => '',
    	read_only => '',
    		},
});

__PACKAGE__->swagger_types( {
    'self_uri' => 'ResourceUri',
    'alternate_links' => 'ARRAY[ResourceUri]',
    'document_properties' => 'ResourceUri',
    'view_properties' => 'ResourceUri',
    'slides' => 'ResourceUri',
    'images' => 'ResourceUri',
    'layout_slides' => 'ResourceUri',
    'master_slides' => 'ResourceUri'
} );

__PACKAGE__->attribute_map( {
    'self_uri' => 'SelfUri',
    'alternate_links' => 'AlternateLinks',
    'document_properties' => 'DocumentProperties',
    'view_properties' => 'ViewProperties',
    'slides' => 'Slides',
    'images' => 'Images',
    'layout_slides' => 'LayoutSlides',
    'master_slides' => 'MasterSlides'
} );

__PACKAGE__->mk_accessors(keys %{__PACKAGE__->attribute_map});


1;
