=begin comment

Copyright (c) 2019 Aspose Pty Ltd

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

=end comment

=cut

package AsposeSlidesCloud::Object::Hyperlink;

require 5.6.0;
use strict;
use warnings;
use utf8;
use JSON qw(decode_json);
use Data::Dumper;
use Module::Runtime qw(use_module);
use Log::Any qw($log);
use Date::Parse;
use DateTime;


use base ("Class::Accessor", "Class::Data::Inheritable");


#
#Hyperlink
#
# NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
# REF: https://github.com/swagger-api/swagger-codegen
#

#
# NOTE: This class is auto generated by the swagger code generator program. 
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
__PACKAGE__->mk_classdata('attribute_map' => {});
__PACKAGE__->mk_classdata('swagger_types' => {});
__PACKAGE__->mk_classdata('method_documentation' => {}); 
__PACKAGE__->mk_classdata('class_documentation' => {});

# new object
sub new { 
    my ($class, %args) = @_; 

	my $self = bless {}, $class;
	
	foreach my $attribute (keys %{$class->attribute_map}) {
		my $args_key = $class->attribute_map->{$attribute};
		$self->$attribute( $args{ $args_key } );
	}
	return $self;
}  

# used by JSON for serialization
sub TO_JSON { 
    my $self = shift;
    my $_data = {};
    foreach my $_key (keys %{$self->attribute_map}) {
        if (defined $self->{$_key}) {
            $_data->{$self->attribute_map->{$_key}} = $self->{$_key};
        }
    }
    return $_data;
}


__PACKAGE__->class_documentation({description => 'Hyperlink',
                                  class => 'Hyperlink',
                                  required => [], # TODO
}                                 );

__PACKAGE__->method_documentation({
    'is_disabled' => {
    	datatype => 'boolean',
    	base_name => 'IsDisabled',
    	description => 'If true Hypelink is not applied. ',
    	format => '',
    	read_only => '',
    		},
    'action_type' => {
    	datatype => 'string',
    	base_name => 'ActionType',
    	description => 'Type of HyperLink action             ',
    	format => '',
    	read_only => '',
    		},
    'external_url' => {
    	datatype => 'string',
    	base_name => 'ExternalUrl',
    	description => 'Specifies the external URL',
    	format => '',
    	read_only => '',
    		},
    'target_slide_index' => {
    	datatype => 'int',
    	base_name => 'TargetSlideIndex',
    	description => 'Index of the target slide',
    	format => '',
    	read_only => '',
    		},
    'target_frame' => {
    	datatype => 'string',
    	base_name => 'TargetFrame',
    	description => 'Target frame',
    	format => '',
    	read_only => '',
    		},
    'tooltip' => {
    	datatype => 'string',
    	base_name => 'Tooltip',
    	description => 'Hyperlink tooltip',
    	format => '',
    	read_only => '',
    		},
    'history' => {
    	datatype => 'boolean',
    	base_name => 'History',
    	description => 'Makes hyperlink viewed when it is invoked.             ',
    	format => '',
    	read_only => '',
    		},
    'highlight_click' => {
    	datatype => 'boolean',
    	base_name => 'HighlightClick',
    	description => 'Determines whether the hyperlink should be highlighted on click.',
    	format => '',
    	read_only => '',
    		},
    'stop_sound_on_click' => {
    	datatype => 'boolean',
    	base_name => 'StopSoundOnClick',
    	description => 'Determines whether the sound should be stopped on hyperlink click',
    	format => '',
    	read_only => '',
    		},
    'color_source' => {
    	datatype => 'string',
    	base_name => 'ColorSource',
    	description => 'Represents the source of hyperlink color',
    	format => '',
    	read_only => '',
    		},
    'sound_base64' => {
    	datatype => 'string',
    	base_name => 'SoundBase64',
    	description => 'Audio data encoded in base64. Represents the playing sound of the hyperlink. ',
    	format => '',
    	read_only => '',
    		},
});

__PACKAGE__->swagger_types( {
    'is_disabled' => 'boolean',
    'action_type' => 'string',
    'external_url' => 'string',
    'target_slide_index' => 'int',
    'target_frame' => 'string',
    'tooltip' => 'string',
    'history' => 'boolean',
    'highlight_click' => 'boolean',
    'stop_sound_on_click' => 'boolean',
    'color_source' => 'string',
    'sound_base64' => 'string'
} );

__PACKAGE__->attribute_map( {
    'is_disabled' => 'IsDisabled',
    'action_type' => 'ActionType',
    'external_url' => 'ExternalUrl',
    'target_slide_index' => 'TargetSlideIndex',
    'target_frame' => 'TargetFrame',
    'tooltip' => 'Tooltip',
    'history' => 'History',
    'highlight_click' => 'HighlightClick',
    'stop_sound_on_click' => 'StopSoundOnClick',
    'color_source' => 'ColorSource',
    'sound_base64' => 'SoundBase64'
} );

__PACKAGE__->mk_accessors(keys %{__PACKAGE__->attribute_map});


1;
