package PROP::Constants;

use strict;
use base qw/Exporter/;

our @EXPORT = qw/DEBUG LIMIT/;

use constant DEBUG => 1;
use constant LIMIT => 5000;

1;

=head1 Name

PROP::Constants

=head1 Description

This class holds various and sundry constants that are common to the
entire SQL framework.

=head1 Constants

=over

=item DEBUG

This constant specifies whether various debugging mechanisms are
active.  This mechanisms greatly aid in the debugging of programming
defects, but impose a run-time penalty.  As such, it should be enabled
in the development environment, but disabled in the production
environment and ddata_sourceng benchmarking.

=item LIMIT

This constant specifies the default number of rows on which a SQL
select statement will operate at a time.  It will not affect the
ultimate algorithmic behavior of the program, but it can greatly
affect run time and resource usage.

=back

=head1 Author

Andrew Gibbs (awgibbs@awgibbs.com,andrew.gibbs@nist.gov)

=head1 Legalese

This software was developed at the National Institute of Standards and
Technology by employees of the Federal Government in the course of
their official duties. Pursuant to title 17 Section 105 of the United
States Code this software is not subject to copyright protection and
is in the public domain. PROP is an experimental system. NIST
assumes no responsibility whatsoever for its use by other parties, and
makes no guarantees, expressed or implied, about its quality,
reliability, or any other characteristic. We would appreciate
acknowledgement if the software is used.  This software can be
redistributed and/or modified freely provided that any derivative
works bear some notice that they are derived from it, and any modified
versions bear some notice that they have been modified.
