#!/usr/bin/env perl

use strict;
use warnings 'FATAL';

use Path::Class;
use lib file(__FILE__)->dir->stringify;
use Test::More tests => 2;

subtest 'ENVs' => sub{
    plan tests => 3;

    use_ok('TestCrudClasses');
    ok($ENV{UR_DBI_NO_COMMIT}, 'no commit is on');
    ok($ENV{UR_USE_DUMMY_AUTOGENERATED_IDS}, 'use dummy ids is on');

};

subtest 'test classes' => sub{
    plan tests => 7;

    for my $class (qw/ Test::Muppet Test::Job Test::Relationship /) {
        my $meta = UR::Object::Type->get($class);
        ok($meta, "test $class meta");
    }

    can_ok('Test::Muppet', 'job');
    can_ok('Test::Muppet', 'relationships');
    can_ok('Test::Muppet', 'friends');
    can_ok('Test::Muppet', 'best_friend');

};

done_testing();
