package App::Manoc::Search::Driver::WinLogon;

use Moose;

our $VERSION = '2.99.2'; ##TRIAL VERSION

extends 'App::Manoc::Search::Driver';

use App::Manoc::Search::Item::IpAddr;

sub search_logon {
    my ( $self, $query, $result ) = @_;

    my $pattern = $query->sql_pattern;
    my $schema  = $self->engine->schema;
    my ( $e, $it );

    my $conditions = {};
    $conditions->{'user'} = { '-like', $pattern };
    if ( $query->limit ) {
        $conditions->{lastseen} = { '>=', $query->start_date };
    }

    $it = $schema->resultset('WinLogon')->search(
        $conditions,
        {
            select   => [ 'user', 'ipaddr', { max => 'lastseen' } ],
            as       => [ 'user', 'ipaddr', 'lastseen' ],
            group_by => 'ipaddr',
        }
    );

    while ( my $e = $it->next ) {
        my $item = App::Manoc::Search::Item::IpAddr->new(
            {
                match     => lc( $e->user ),
                addr      => $e->ipaddr->address,
                timestamp => $e->get_column('lastseen'),
            }
        );
        $result->add_item($item);
    }
}

__END__

=pod

=head1 NAME

App::Manoc::Search::Driver::WinLogon

=head1 VERSION

version 2.99.2

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
