package App::Manoc::DB::ResultSet::DeviceIfStatus;
#ABSTRACT: ResultSet class for IfStatus
use strict;
use warnings;

our $VERSION = '2.99.4'; ##TRIAL VERSION

use parent 'App::Manoc::DB::ResultSet';

use App::Manoc::DB::Search::Result::Iface;


sub manoc_search {
    my ( $self, $query, $result ) = @_;

    my $type    = $query->query_type;
    my $pattern = $query->sql_pattern;

    return unless $type eq 'inventory';

    my $rs = $self->search(
        {
            description => { '-like' => $pattern }
        },
        {
            order_by => 'description',
            prefetch => { 'interface' => 'device' },
        },
    );
    while ( my $e = $rs->next ) {
        my $item = App::Manoc::DB::Search::Result::Iface->new(
            {
                interface => $e->interface,
                text      => $e->description,
            }
        );
        $result->add_item($item);
    }
}

1;

__END__

=pod

=head1 NAME

App::Manoc::DB::ResultSet::DeviceIfStatus - ResultSet class for IfStatus

=head1 VERSION

version 2.99.4

=head1 METHODS

=head2 manoc_search(  $query, $result)

Support for Manoc search feature

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
