# Generated by default/object.tt
package Paws::AccessAnalyzer::NetworkOriginConfiguration;
  use Moose;
  has InternetConfiguration => (is => 'ro', isa => 'Paws::AccessAnalyzer::InternetConfiguration', request_name => 'internetConfiguration', traits => ['NameInRequest']);
  has VpcConfiguration => (is => 'ro', isa => 'Paws::AccessAnalyzer::VpcConfiguration', request_name => 'vpcConfiguration', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AccessAnalyzer::NetworkOriginConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AccessAnalyzer::NetworkOriginConfiguration object:

  $service_obj->Method(Att1 => { InternetConfiguration => $value, ..., VpcConfiguration => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AccessAnalyzer::NetworkOriginConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->InternetConfiguration

=head1 DESCRIPTION

The proposed C<InternetConfiguration> or C<VpcConfiguration> to apply
to the Amazon S3 Access point. You can make the access point accessible
from the internet, or you can specify that all requests made through
that access point must originate from a specific virtual private cloud
(VPC). You can specify only one type of network configuration. For more
information, see Creating access points
(https://docs.aws.amazon.com/AmazonS3/latest/dev/creating-access-points.html).

=head1 ATTRIBUTES


=head2 InternetConfiguration => L<Paws::AccessAnalyzer::InternetConfiguration>

The configuration for the Amazon S3 access point with an C<Internet>
origin.


=head2 VpcConfiguration => L<Paws::AccessAnalyzer::VpcConfiguration>





=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AccessAnalyzer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

