# Generated by default/object.tt
package Paws::MWAA::NetworkConfiguration;
  use Moose;
  has SecurityGroupIds => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has SubnetIds => (is => 'ro', isa => 'ArrayRef[Str|Undef]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::MWAA::NetworkConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MWAA::NetworkConfiguration object:

  $service_obj->Method(Att1 => { SecurityGroupIds => $value, ..., SubnetIds => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MWAA::NetworkConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->SecurityGroupIds

=head1 DESCRIPTION

The VPC networking components used to secure and enable network traffic
between the AWS resources for your environment. To learn more, see
About networking on Amazon MWAA
(https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html).

=head1 ATTRIBUTES


=head2 SecurityGroupIds => ArrayRef[Str|Undef]

A list of 1 or more security group IDs. Accepts up to 5 security group
IDs. A security group must be attached to the same VPC as the subnets.
To learn more, see Security in your VPC on Amazon MWAA
(https://docs.aws.amazon.com/mwaa/latest/userguide/vpc-security.html).


=head2 SubnetIds => ArrayRef[Str|Undef]

A list of 2 subnet IDs. B<Required> to create an environment. Must be
private subnets in two different availability zones. A subnet must be
attached to the same VPC as the security group.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MWAA>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

