package Business::EDI::CodeList::InstructionDescriptionCode;

use base 'Business::EDI::CodeList';
my $VERSION     = 0.02;
sub list_number {4401;}
my $usage       = 'C';

# 4401  Instruction description code                            [C]
# Desc: Code specifying an instruction.
# Repr: an..3

my %code_hash = (
'AA' => [ 'Send credit note',
    'Send a credit note.' ],
'AB' => [ 'Change invoice',
    'Send invoice, taking into account specified discrepancies.' ],
'AC' => [ 'Advise by airmail',
    'Instruction to advise party by airmail.' ],
'AD' => [ 'Advise',
    'Instruction to advise a party.' ],
'AE' => [ 'Read meter at beginning of supply',
    'Read the meter when the supply period starts.' ],
'AF' => [ 'Stop delivery process',
    'Instruction to cease delivery.' ],
'AG' => [ 'Send replacement',
    'The identified item must be sent for replacement.' ],
'AH' => [ 'Pick-up',
    'The identified item is to be picked up.' ],
'AI' => [ 'Advise by telecommunication',
    'Advise of documentary credit by telecommunication.' ],
'AJ' => [ 'Advise by fax',
    'Instruction to advise party by fax.' ],
'AK' => [ 'By registered airmail',
    'Issue documentary credit by registered airmail.' ],
'AL' => [ 'By registered airmail in one set',
    'Deliver documents in one set by registered airmail.' ],
'AM' => [ 'By registered airmail in two sets',
    'Deliver documents in two sets by registered airmail.' ],
'AN' => [ 'Authorized to debit our account when due',
    'The receiver is authorized to debit the account of the sender when due.' ],
'AO' => [ 'Authorized to reimburse yourselves on the reimbursing bank',
    'when due The receiver is authorized to reimburse themselves on the reimbursing bank when due.' ],
'AP' => [ 'Advise by phone',
    'Instruction to advise party by phone.' ],
'AQ' => [ 'Upon receipt and verification of documents we shall credit',
    'your account with us when due Upon receipt and verification of documents we shall credit your account with us when due.' ],
'AR' => [ 'Protest non-payment',
    'Protest is to be made in case of non-payment.' ],
'AS' => [ 'Protest non-acceptance',
    'Protest is to be made in case of non-acceptance.' ],
'AT' => [ 'Advise by telex',
    'Instruction to advise party by telex.' ],
'AU' => [ 'Protest non-acceptance and non-payment',
    'Protest is to be made in case of non-acceptance and non- payment.' ],
'AV' => [ 'May not be waived',
    'Not permitted to be waived.' ],
'AW' => [ 'May be waived',
    'Permitted to be waived.' ],
'AX' => [ 'Acceptance and/or payment may be deferred until the arrival',
    'of goods Acceptance and/or payment may be deferred until the goods have arrived.' ],
'AY' => [ 'Acceptance and/or payment may not be deferred until the',
    'arrival of goods Acceptance and/or payment may not be deferred until the goods have arrived.' ],
'AZ' => [ 'If documents are not honoured on arrival of goods then',
    "warehouse goods Goods are to be warehoused if documents are not taken up on the goods' arrival." ],
'BA' => [ 'If documents are not honoured on arrival of goods then',
    "warehouse goods and insure against fire Goods are to be warehoused and insured against fire if documents are not taken up on the goods' arrival." ],
'BB' => [ 'If documents are not honoured on arrival of goods then',
    "warehouse goods and insure against usual risks Goods are to be warehoused and insured against the usual risks if documents are not taken up on the goods' arrival." ],
'BC' => [ 'Case of need party has power to give instructions',
    'Case of need party has the power to give instructions.' ],
'BD' => [ 'Case of need party may advise only',
    'The case of need party may advise only.' ],
'BE' => [ 'Draft must be returned after acceptance',
    'The draft must be returned after acceptance.' ],
'BF' => [ 'Advise by mail',
    'Instruction to advise party by mail.' ],
'BG' => [ 'Release documents against acceptance',
    'The documents are to be released against acceptance.' ],
'BH' => [ 'Release documents against payment',
    'The documents are to be released against payment.' ],
'BI' => [ "Release documents against issuance of drawee's undertaking",
    "The documents are to be released against issuance of drawee's undertaking." ],
'BJ' => [ "Release documents against issuance of presenting bank's",
    "undertaking The documents are to be released against issuance of presenting bank's undertaking." ],
'BK' => [ "Release documents against issuance of named bank's",
    "undertaking The documents are to be released against issuance of named bank's undertaking." ],
'BL' => [ "Release documents against issuance of drawee's signed",
    "promissory note The documents are to be released against issuance of drawee's signed promissory note." ],
'BM' => [ "Release documents against issuance of presenting bank's",
    "signed promissory note The documents are to be released against issuance of presenting bank's signed promissory note." ],
'BN' => [ "Release documents against issuance of named bank's signed",
    "promissory note The documents are to be released against issuance of named bank's signed promissory note." ],
'BO' => [ "Release documents against issuance of drawee's signed trust",
    "receipt The documents are to be released against issuance of drawee's signed trust receipt." ],
'BP' => [ 'Release documents against acceptance and aval of presenting',
    'bank The documents are to be released against acceptance and aval of presenting bank.' ],
'BQ' => [ 'Release documents against acceptance and aval of named bank',
    'The documents are to be released against acceptance and aval of named bank.' ],
'BR' => [ 'Remit proceeds',
    'The proceeds are to be remitted.' ],
'BS' => [ 'Remit proceeds to intermediary bank',
    'The proceeds are to be remitted to the intermediary bank.' ],
'BT' => [ 'Accept provisional deposit if covered in local currency',
    'Where the currency of the collection is not available, the collection bank is authorised to accept a provisional deposit in local currency.' ],
'BU' => [ 'Read meter at end of supply',
    'Read the meter when the supply period ends.' ],
'BV' => [ 'Replace if necessary',
    'Replace the item if necessary.' ],
'BW' => [ 'Replace',
    'Replace the item.' ],
'BX' => [ 'Do not replace',
    'Do not replace the item.' ],
'BY' => [ 'Remedial action for incorrect account number',
    'Instruction to take the appropriate remedial action to correct the referenced account number.' ],
'BZ' => [ 'Remedial action for unknown account',
    'Instruction to take the appropriate remedial action because the referenced account is not known.' ],
'CA' => [ 'Remedial action for account frozen by legal authorities',
    'Instruction to take the appropriate remedial action because the referenced account has been frozen by legal authorities.' ],
'CB' => [ 'Remedial action for deceased account holder',
    'Instruction to take remedial action that is appropriate because the holder of the referenced account is dead.' ],
'CC' => [ 'Remedial action for refusal by account owner or ultimate',
    'beneficiary Instruction to take the appropriate remedial action because the account owner or ultimate beneficiary has refused to accept the transaction.' ],
'CD' => [ 'Remedial action for unjustified charges claim on',
    'beneficiary Instruction to take the appropriate remedial action because it is claimed that the charges on the beneficiary are unjustified.' ],
'CE' => [ 'Remedial action for unrecognised destination bank or branch',
    'identification Instruction to take the appropriate remedial action because the destination bank or branch identification is not recognised.' ],
'CF' => [ 'Remedial action for closed destination account',
    'Instruction to take the appropriate remedial action beause the destination account has been closed.' ],
'CG' => [ 'Remedial action for transaction over credit limit',
    'Instruction to take the appropriate remedial action because the transaction exceeds an agreed credit limit.' ],
'CH' => [ 'Remedial action for disallowed transaction type',
    'Instruction to take the appropriate remedial action because the type of transaction is not allowed.' ],
'CI' => [ 'Remedial action for insufficient funds',
    'Instruction to take the appropriate remedial action because of insufficient funds.' ],
'CJ' => [ 'Remedial action for no prior mandate in place',
    'Instruction to take the appropriate remedial action because no mandate has been agreed beforehand.' ],
'CK' => [ 'Remedial action for revoked mandate',
    'Instruction to take the appropriate remedial action because the mandate has been revoked.' ],
'CL' => [ 'Remedial action for unknown party',
    'Instruction to take the appropriate remedial action because a party is unknown.' ],
'CM' => [ 'Remedial action for incorrect bank information',
    'Instruction to take the appropriate remedial action because the specified bank information is incorrect or invalid.' ],
'CN' => [ 'Remedial action for duplicated transaction',
    'Instruction to take the appropriate remedial action because a transaction has been duplicated.' ],
'CO' => [ 'Convert',
    'Convert the message into other format.' ],
'CP' => [ 'Remedial action for transaction not completed for a reason',
    'that cannot be disclosed Instructs the recipient of the returned message to take the appropriate remedial action when the transaction has been rejected for a reason that, for legal or other reasons, cannot be disclosed.' ],
'CS' => [ 'Send by courier services',
    'Send the item(s) by courier services.' ],
'CZ' => [ 'Specific clearing',
    'Item(s) are subject to specific clearing.' ],
'DA' => [ 'Without',
    'The bank advising the documentary credit is not requested to confirm the credit.' ],
'DB' => [ 'May add',
    'The bank advising the documentary credit may add its confirmation to the documentary credit.' ],
'DC' => [ 'Confirm',
    'The bank advising the documentary credit is requested to confirm the credit.' ],
'DD' => [ 'By registered mail',
    'Issue documentary credit by registered mail.' ],
'DE' => [ 'By courier service',
    'Issue documentary credit by courier service.' ],
'DF' => [ 'By teletransmission',
    'Issue documentary credit by teletransmission.' ],
'DG' => [ 'Preadvice by teletransmission',
    'Preadvise documentary credit by teletransmission.' ],
'DH' => [ 'By courier service in one set',
    'Deliver documents in one set by courier service.' ],
'DI' => [ 'By courier service in two sets',
    'Deliver documents in two sets by courier service.' ],
'DJ' => [ 'By registered mail in one set',
    'Deliver documents in one set by registered mail.' ],
'DK' => [ 'By registered mail in two sets',
    'Deliver documents in two sets by registered mail.' ],
'DN' => [ 'Per teletransmission',
    'Deliver documents by teletransmission.' ],
'DO' => [ 'Advise beneficiary by phone',
    'Advise beneficiary of documentary credit by phone.' ],
'DP' => [ 'Late presentation of documents within documentary credit',
    'validity acceptable Late presentation of documents with the documentary credit validity is acceptable.' ],
'EI' => [ 'EDI',
    'Instructions to advise beneficiary by EDI.' ],
'EM' => [ 'Electronic mail',
    'Instructions to advise beneficiary by electronic mail.' ],
'EX' => [ 'Expedite',
    'Forward the information to requested party immediately.' ],
'IM' => [ 'Send by regular mail',
    'Send the tem(s) by regular mail.' ],
'PT' => [ 'Print',
    'Print the item(s).' ],
'QC' => [ 'Quality control held',
    'Goods to be held from distribution by stockholder until a quality control assessment is completed by the manufacturer.' ],
'QE' => [ 'Quality control embargo',
    'Quality control assessment is negative, goods are to be held from distribution by stockholder.' ],
'RL' => [ 'Released',
    'Goods are released by manufacturer for distribution by stockholder.' ],
'RM' => [ 'Send by registered mail',
    'Send the item(s) by registered mail.' ],
'SW' => [ 'S.W.I.F.T.',
    'Instructions to advise beneficiary by S.W.I.F.T.' ],
'SX' => [ 'Take once a day',
    'To be taken once daily.' ],
'SY' => [ 'Take two times a day',
    'To be taken two times each day.' ],
'SZ' => [ 'Take three times a day',
    'To be taken three times each day.' ],
'TA' => [ 'Take four times a day',
    'To be taken four times daily.' ],
);
sub get_codes { return \%code_hash; }

1;
