package Business::EDI::CodeList::PaymentTermsTypeCodeQualifier;

use base 'Business::EDI::CodeList';
my $VERSION     = 0.02;
sub list_number {4279;}
my $usage       = 'B';

# 4279  Payment terms type code qualifier                       [B]
# Desc: Code qualifying the type of payment terms.
# Repr: an..3

my %code_hash = (
'1' => [ 'Basic',
    'Payment conditions normally applied.' ],
'2' => [ 'End of month',
    'Payments are due at end of month.' ],
'3' => [ 'Fixed date',
    'Payments are due on the fixed date specified.' ],
'4' => [ 'Deferred',
    'Payments are deferred beyond the normal due date.' ],
'5' => [ 'Discount not applicable',
    'Payment terms on which discounts are not applicable.' ],
'6' => [ 'Mixed',
    'Different payment terms negotiated under a documentary credit.' ],
'7' => [ 'Extended',
    'Payment is extended beyond the normal due date.' ],
'8' => [ 'Basic discount offered',
    'Payment terms reflect the basic offered discount.' ],
'9' => [ 'Proximo',
    'Occurring in the next month after present.' ],
'10' => [ 'Instant',
    'Payment is due on receipt of invoice.' ],
'11' => [ 'Elective',
    'Payment terms to be chosen by buyer (from options separately advised).' ],
'12' => [ '10 days after end of month',
    'Payment due ten days after end of a calendar month.' ],
'13' => [ 'Seller to advise buyer',
    'Seller will advise buyer of payment terms by separate transaction.' ],
'14' => [ 'Paid against statement',
    'Payments are to be made against statement.' ],
'15' => [ 'No charge',
    'Payment terms have no charge.' ],
'16' => [ 'Not yet defined',
    'Payment terms are not yet defined.' ],
'17' => [ 'Ultimo',
    'Payment is due the end of the current or specified month.' ],
'18' => [ 'Previously agreed upon',
    'Payment terms have been previously agreed upon.' ],
'19' => [ 'United States funds',
    'The payment terms require the use of United States funds.' ],
'20' => [ 'Penalty terms',
    'Payment terms on which penalties apply.' ],
'21' => [ 'Payment by instalment',
    'Payment terms are based on instalment payments.' ],
'22' => [ 'Discount',
    'Payment terms on which discounts are applicable.' ],
'23' => [ 'Available by sight payment',
    'Payment made at sight.' ],
'24' => [ 'Available by deferred payment',
    'Payment made at deferred date.' ],
'25' => [ 'Available by acceptance',
    'Payment on acceptance.' ],
'26' => [ 'Available by negotiation with any bank',
    'Payment made by negotiation with any bank.' ],
'27' => [ 'Available by negotiation with any bank in ...',
    'Payment made by negotiation with any bank in a specified location.' ],
'28' => [ 'Available by negotiation by named bank',
    'Payment made by negotiation with a specified financial institution.' ],
'29' => [ 'Available by negotiation',
    'Payment made by negotiation.' ],
'30' => [ 'Adjustment payment',
    'Payment adjusted for outstanding credits or debits.' ],
'31' => [ 'Late payment',
    'Payment after due date.' ],
'32' => [ 'Advanced payment',
    'Payment in advance of due date.' ],
'33' => [ 'Payment by instalments according to progress (as agreed)',
    'Payment by instalments according to progress (as agreed).' ],
'34' => [ 'Payment by instalments according to progress (to be agreed)',
    'Payment by instalments according to progress (to be agreed).' ],
'35' => [ 'Nonstandard',
    'Terms of payment differ from the normal terms.' ],
'36' => [ 'Tenor payment terms',
    'Payment to be made according to bilaterally agreed conditions between buyer and seller.' ],
'37' => [ 'Complete payment',
    'Payment must be made for complete value and may not be paid in instalments.' ],
'38' => [ 'Payment terms defined in consolidated invoice',
    'Payment terms are specified in a consolidated invoice.' ],
'39' => [ 'Payment upon completion',
    'The payment terms require payment upon completion.' ],
'40' => [ 'Partial advance',
    'The payment terms require a partial payment in advance of completion.' ],
'41' => [ 'Consignment',
    'The payment terms are that the goods will be paid for when they are sold or consumed.' ],
'42' => [ 'Inter-company account',
    'The payment terms involve the use of an inter-company account.' ],
'43' => [ 'Sell by note',
    'The payment terms involve a debtor who promises to pay a definite sum of money on demand or at a definite time in the future.' ],
'44' => [ 'Supplier floor plan',
    'The payment terms involve payment for merchandise owned by a third party.' ],
'45' => [ 'Contract basis',
    'The payment terms are based on a contract with a vendor.' ],
'46' => [ 'Credit controlled',
    'The payment terms involve the monitoring of credit by the grantor.' ],
'47' => [ 'Dating given',
    'The payment terms in which suppliers may extend seasonal dating.' ],
'48' => [ 'Trade acceptance',
    'A trade acceptance is a written acknowledgement of the sale of goods and promise to pay at a definite date and place.' ],
'49' => [ 'Cost plus',
    'The payment terms permit reimbursement of costs plus other authorised changes.' ],
'50' => [ 'Letter of credit',
    'The payment terms require the use of a letter of credit.' ],
'51' => [ 'Lease agreement',
    'The payment terms are included in the lease agreement.' ],
'52' => [ 'Cash On Delivery (COD)',
    'The payment terms are cash is due on delivery of merchandise.' ],
'53' => [ 'Cash by state law',
    'The payment terms are dictated by state law requiring payment of cash.' ],
'54' => [ 'Bank transfer',
    'The payment terms require the use of bank transfer.' ],
'55' => [ 'Cash on arrival',
    'The payment terms require payment by cash on arrival of the goods or services.' ],
'56' => [ 'Cash',
    'The payment terms are that payments are made in cash.' ],
'57' => [ 'Cash discount terms apply',
    'The payment terms are that a discount is applicable if the payment is made in cash.' ],
'58' => [ 'Cash with order',
    'The payment terms require the payment in cash with placement of the order.' ],
'59' => [ 'Cash per vendor request',
    'The payment terms involve a vendor request for payment by cash.' ],
'60' => [ 'Irrevocable letter of credit',
    'The payment terms require the use of an irrevocable letter of credit.' ],
'61' => [ 'Documents against acceptance',
    'The payment terms require acceptance of liability before document transfer.' ],
'62' => [ 'Charge card',
    'The payment terms permit the use of a charge card to effect payment.' ],
'63' => [ 'Documents against payment',
    'The payment terms require payment before document transfer.' ],
'64' => [ 'Usance bill',
    'The payment terms are based on the time allowed by commercial usage for the payment of foreign bills of exchange.' ],
'65' => [ 'Letter of credit at sight',
    'The payment terms require the presentation of a letter of credit.' ],
'66' => [ 'Secured account',
    'The payment terms call for the use of a secured account.' ],
'67' => [ 'Basic commission terms',
    'The payment terms call for the use of basic commission terms.' ],
'68' => [ 'Deposit required',
    'The payment terms require a deposit be provided.' ],
'69' => [ 'Discount with prompt pay',
    'The payment terms include a discount when payment is made within a time frame designated as prompt pay.' ],
'70' => [ 'Discount with advance payment',
    'The payment terms include a discount when payment is made in advance.' ],
'71' => [ 'Certified cheque',
    'The payment terms require the use of a certified cheque.' ],
'72' => [ 'Cash against documents',
    'The payment terms require cash payment before document transfer.' ],
'73' => [ 'Bill of exchange',
    'The payment terms require the use of bill of exchange.' ],
'74' => [ 'Progressive discount',
    'The payment terms include a progressive discount based on the amount and speed with which payments are made.' ],
'75' => [ 'Lump sum',
    'The payment term requires a lump sum payment.' ],
'76' => [ 'Fixed fee',
    'The payment term requires a fixed fee payment.' ],
'77' => [ 'Promissory note',
    'The payment term requires the use of a promissory note as a means of payment.' ],
'78' => [ 'Factoring',
    'Payment term requires payment being made by the factoring company according to the agreement between buyer, bank and factoring company.' ],
'ZZZ' => [ 'Mutually defined',
    'A code assigned within a code list to be used on an interim basis and as defined among trading partners until a precise code can be assigned to the code list.' ],
);
sub get_codes { return \%code_hash; }

1;
