package Business::EDI::CodeList::ReferenceCodeQualifier;

use base 'Business::EDI::CodeList';
my $VERSION     = 0.02;
sub list_number {1153;}
my $usage       = 'C';

# *    1153  Reference code qualifier                                [C]
# Desc: Code qualifying a reference.
# Repr: an..3

my %code_hash = (
'AAA' => [ 'Order acknowledgement document identifier',
    '(1018) Reference number identifying the acknowledgement of an order.' ],
'AAB' => [ 'Proforma invoice document identifier',
    '[1088] Reference number to identify a proforma invoice.' ],
'AAC' => [ 'Documentary credit identifier',
    '[1172] Reference number to identify a documentary credit.' ],
'AAD' => [ 'Contract document addendum identifier',
    '[1318] Reference number to identify an addendum to a contract.' ],
'AAE' => [ 'Goods declaration number',
    'Reference number assigned to a goods declaration.' ],
'AAF' => [ 'Debit card number',
    'A reference number identifying a debit card.' ],
'AAG' => [ 'Offer number',
    '(1332) Reference number assigned by issuing party to an offer.' ],
'AAH' => [ "Bank's batch interbank transaction reference number",
    'Reference number allocated by the bank to a batch of different underlying interbank transactions.' ],
'AAI' => [ "Bank's individual interbank transaction reference number",
    'Reference number allocated by the bank to one specific interbank transaction.' ],
'AAJ' => [ 'Delivery order number',
    'Reference number assigned by issuer to a delivery order.' ],
'AAK' => [ 'Despatch advice number',
    'Reference number assigned by issuing party to a despatch advice.' ],
'AAL' => [ 'Drawing number',
    'Reference number identifying a specific product drawing.' ],
'AAM' => [ 'Waybill number',
    'Reference number assigned to a waybill, see: 1001 = 700.' ],
'AAN' => [ 'Delivery schedule number',
    'Reference number assigned by buyer to a delivery schedule.' ],
'AAO' => [ 'Consignment identifier, consignee assigned',
    '[1362] Reference number assigned by the consignee to identify a particular consignment.' ],
'AAP' => [ 'Partial shipment identifier',
    '[1310] Identifier of a shipment which is part of an order.' ],
'AAQ' => [ 'Transport equipment identifier',
    '[8260] To identify a piece if transport equipment e.g. container or unit load device.' ],
'AAR' => [ 'Municipality assigned business registry number',
    'A reference number assigned by a municipality to identify a business.' ],
'AAS' => [ 'Transport contract document identifier',
    '[1188] Reference number to identify a document evidencing a transport contract.' ],
'AAT' => [ 'Master label number',
    'Identifies the master label number of any package type.' ],
'AAU' => [ 'Despatch note document identifier',
    '[1128] Reference number to identify a Despatch Note.' ],
'AAV' => [ 'Enquiry number',
    'Reference number assigned to an enquiry.' ],
'AAW' => [ 'Docket number',
    'A reference number identifying the docket.' ],
'AAX' => [ 'Civil action number',
    'A reference number identifying the civil action.' ],
'AAY' => [ "Carrier's agent reference number",
    'Reference number assigned by the carriers agent to a transaction.' ],
'AAZ' => [ 'Standard Carrier Alpha Code (SCAC) number',
    'For maritime shipments, this code qualifies a Standard Alpha Carrier Code (SCAC) as issued by the United Stated National Motor Traffic Association Inc.' ],
'ABA' => [ 'Customs valuation decision number',
    'Reference by an importing party to a previous decision made by a Customs administration regarding the valuation of goods.' ],
'ABB' => [ 'End use authorization number',
    'Reference issued by a Customs administration authorizing a preferential rate of duty if a product is used for a specified purpose, see: 1001 = 990.' ],
'ABC' => [ 'Anti-dumping case number',
    'Reference issued by a Customs administration pertaining to a past or current investigation of goods "dumped" at a price lower than the exporter\'s domestic market price.' ],
'ABD' => [ 'Customs tariff number',
    '(7357) Code number of the goods in accordance with the tariff nomenclature system of classification in use where the Customs declaration is made.' ],
'ABE' => [ "Declarant's reference number",
    'Unique reference number assigned to a document or a message by the declarant for identification purposes.' ],
'ABF' => [ 'Repair estimate number',
    'A number identifying a repair estimate.' ],
'ABG' => [ 'Customs decision request number',
    'Reference issued by Customs pertaining to a pending tariff classification decision requested by an importer or agent.' ],
'ABH' => [ 'Sub-house bill of lading number',
    'Reference assigned to a sub-house bill of lading.' ],
'ABI' => [ 'Tax payment identifier',
    '[1168] Reference number identifying a payment of a duty or tax e.g. under a transit procedure.' ],
'ABJ' => [ 'Quota number',
    'Reference number allocated by a government authority to identify a quota.' ],
'ABK' => [ 'Transit (onward carriage) guarantee (bond) number',
    'Reference number to identify the guarantee or security provided for Customs transit operation (CCC).' ],
'ABL' => [ 'Customs guarantee number',
    'Reference assigned to a Customs guarantee.' ],
'ABM' => [ 'Replacing part number',
    'New part number which replaces the existing part number.' ],
'ABN' => [ "Seller's catalogue number",
    "Identification number assigned to a seller's catalogue." ],
'ABO' => [ "Originator's reference",
    'A unique reference assigned by the originator.' ],
'ABP' => [ "Declarant's Customs identity number",
    'Reference to the party whose posted bond or security is being declared in order to accept responsibility for a goods declaration and the applicable duties and taxes.' ],
'ABQ' => [ 'Importer reference number',
    'Reference number assigned by the importer to identify a particular shipment for his own purposes.' ],
'ABR' => [ 'Export clearance instruction reference number',
    'Reference number of the clearance instructions given by the consignor through different means.' ],
'ABS' => [ 'Import clearance instruction reference number',
    'Reference number of the import clearance instructions given by the consignor/consignee through different means.' ],
'ABT' => [ 'Goods declaration document identifier, Customs',
    '[1426] Reference number, assigned or accepted by Customs, to identify a goods declaration.' ],
'ABU' => [ 'Article number',
    'A number that identifies an article.' ],
'ABV' => [ 'Intra-plant routing',
    'To define routing within a plant.' ],
'ABW' => [ 'Stock keeping unit number',
    'A number that identifies the stock keeping unit.' ],
'ABX' => [ 'Text Element Identifier deletion reference',
    'The reference used within a given TEI (Text Element Identifier) which is to be deleted.' ],
'ABY' => [ 'Allotment identification (Air)',
    'Reference assigned to guarantied capacity on one or more specific flights on specific date(s) to third parties as agents and other airlines.' ],
'ABZ' => [ 'Vehicle licence number',
    'Number of the licence issued for a vehicle by an agency of government.' ],
'AC' => [ 'Air cargo transfer manifest',
    'A number assigned to an air cargo list of goods to be transferred.' ],
'ACA' => [ 'Cargo acceptance order reference number',
    'Reference assigned to the cargo acceptance order.' ],
'ACB' => [ 'US government agency number',
    'A number that identifies a United States Government agency.' ],
'ACC' => [ 'Shipping unit identification',
    'Identifying marks on the outermost unit that is used to transport merchandise.' ],
'ACD' => [ 'Additional reference number',
    'Reference number provided in addition to another given reference.' ],
'ACE' => [ 'Related document number',
    'Reference number identifying a related document.' ],
'ACF' => [ 'Addressee reference',
    'A reference number of an addressee.' ],
'ACG' => [ 'ATA carnet number',
    'Reference number assigned to an ATA carnet.' ],
'ACH' => [ 'Packaging unit identification',
    'Identifying marks on packing units.' ],
'ACI' => [ 'Outerpackaging unit identification',
    'Identifying marks on packing units contained within an outermost shipping unit.' ],
'ACJ' => [ 'Customer material specification number',
    'Number for a material specification given by customer.' ],
'ACK' => [ 'Bank reference',
    'Cross reference issued by financial institution.' ],
'ACL' => [ 'Principal reference number',
    'A number that identifies the principal reference.' ],
'ACN' => [ 'Collection advice document identifier',
    '[1030] Reference number to identify a collection advice document.' ],
'ACO' => [ 'Iron charge number',
    'Number attributed to the iron charge for the production of steel products.' ],
'ACP' => [ 'Hot roll number',
    'Number attributed to a hot roll coil.' ],
'ACQ' => [ 'Cold roll number',
    'Number attributed to a cold roll coil.' ],
'ACR' => [ 'Railway wagon number',
    '(8260) Registered identification initials and numbers of railway wagon. Synonym: Rail car number.' ],
'ACT' => [ 'Unique claims reference number of the sender',
    'A number that identifies the unique claims reference of the sender.' ],
'ACU' => [ 'Loss/event number',
    'To reference to the unique number that is assigned to each major loss hitting the reinsurance industry.' ],
'ACV' => [ 'Estimate order reference number',
    'Reference number assigned by the ordering party of the estimate order.' ],
'ACW' => [ 'Reference number to previous message',
    'Reference number assigned to the message which was previously issued (e.g. in the case of a cancellation, the primary reference of the message to be cancelled will be quoted in this element).' ],
'ACX' => [ "Banker's acceptance",
    "Reference number for banker's acceptance issued by the accepting financial institution." ],
'ACY' => [ 'Duty memo number',
    'Reference number assigned by customs to a duty memo.' ],
'ACZ' => [ 'Equipment transport charge number',
    'Reference assigned to a specific equipment transportation charge.' ],
'ADA' => [ "Buyer's item number",
    'Reference number assigned by the buyer to an item.' ],
'ADB' => [ 'Matured certificate of deposit',
    'Reference number for certificate of deposit allocated by issuing financial institution.' ],
'ADC' => [ 'Loan',
    'Reference number for loan allocated by lending financial institution.' ],
'ADD' => [ 'Analysis number/test number',
    'Number given to a specific analysis or test operation.' ],
'ADE' => [ 'Account number',
    'Identification number of an account.' ],
'ADF' => [ 'Treaty number',
    'A number that identifies a treaty.' ],
'ADG' => [ 'Catastrophe number',
    'A number that identifies a catastrophe.' ],
'ADI' => [ 'Bureau signing (statement reference)',
    'A statement reference that identifies a bureau signing.' ],
'ADJ' => [ 'Company / syndicate reference 1',
    'First reference of a company/syndicate.' ],
'ADK' => [ 'Company / syndicate reference 2',
    'Second reference of a company/syndicate.' ],
'ADL' => [ 'Ordering customer consignment reference number',
    'Reference number assigned to the consignment by the ordering customer.' ],
'ADM' => [ "Shipowner's authorization number",
    'Reference number assigned by the shipowner as an authorization number to transport certain goods (such as hazardous goods, cool or reefer goods).' ],
'ADN' => [ 'Inland transport order number',
    'Reference number assigned by the principal to the transport order for inland carriage.' ],
'ADO' => [ 'Container work order reference number',
    'Reference number assigned by the principal to the work order for a (set of) container(s).' ],
'ADP' => [ 'Statement number',
    'A reference number identifying a statement.' ],
'ADQ' => [ 'Unique market reference',
    'A number that identifies a unique market.' ],
'ADT' => [ 'Group accounting',
    'A number that identifies group accounting.' ],
'ADU' => [ 'Broker reference 1',
    'First reference of a broker.' ],
'ADV' => [ 'Broker reference 2',
    'Second reference of a broker.' ],
'ADW' => [ "Lloyd's claims office reference",
    "A number that identifies a Lloyd's claims office." ],
'ADX' => [ 'Secure delivery terms and conditions agreement reference',
    'A reference to a secure delivery terms and conditions agreement. A secured delivery agreement is an agreement containing terms and conditions to secure deliveries in case of failure in the production or logistics process of the supplier.' ],
'ADY' => [ 'Report number',
    'Reference to a report to Customs by a carrier at the point of entry, encompassing both conveyance and consignment information.' ],
'ADZ' => [ 'Trader account number',
    'Number assigned by a Customs authority which uniquely identifies a trader (i.e. importer, exporter or declarant) for Customs purposes.' ],
'AE' => [ 'Authorization for expense (AFE) number',
    'A number that identifies an authorization for expense (AFE).' ],
'AEA' => [ 'Government agency reference number',
    'Coded reference number that pertains to the business of a government agency.' ],
'AEB' => [ 'Assembly number',
    'A number that identifies an assembly.' ],
'AEC' => [ 'Symbol number',
    'A number that identifies a symbol.' ],
'AED' => [ 'Commodity number',
    'A number that identifies a commodity.' ],
'AEE' => [ 'Eur 1 certificate number',
    'Reference number assigned to a Eur 1 certificate.' ],
'AEF' => [ 'Customer process specification number',
    'Retrieval number for a process specification defined by customer.' ],
'AEG' => [ 'Customer specification number',
    'Retrieval number for a specification defined by customer.' ],
'AEH' => [ 'Applicable instructions or standards',
    'Instructions or standards applicable for the whole message or a message line item. These instructions or standards may be published by a neutral organization or authority or another party concerned.' ],
'AEI' => [ 'Registration number of previous Customs declaration',
    'Registration number of the Customs declaration lodged for the previous Customs procedure.' ],
'AEJ' => [ 'Post-entry reference',
    'Reference to a message related to a post-entry.' ],
'AEK' => [ 'Payment order number',
    'A number that identifies a payment order.' ],
'AEL' => [ 'Delivery number (transport)',
    'Reference number by which a haulier/carrier will announce himself at the container terminal or depot when delivering equipment.' ],
'AEM' => [ 'Transport route',
    'A predefined and identified sequence of points where goods are collected, agreed between partners, e.g. the party in charge of organizing the transport and the parties where goods will be collected. The same collecting points may be included in different transport routes, but in a different sequence.' ],
'AEN' => [ "Customer's unit inventory number",
    'Number assigned by customer to a unique unit for inventory purposes.' ],
'AEO' => [ 'Product reservation number',
    'Number assigned by seller to identify reservation of specified products.' ],
'AEP' => [ 'Project number',
    'Reference number assigned to a project.' ],
'AEQ' => [ 'Drawing list number',
    'Reference number identifying a drawing list.' ],
'AER' => [ 'Project specification number',
    'Reference number identifying a project specification.' ],
'AES' => [ 'Primary reference',
    'A number that identifies the primary reference.' ],
'AET' => [ 'Request for cancellation number',
    'A number that identifies a request for cancellation.' ],
'AEU' => [ "Supplier's control number",
    'Reference to a file regarding a control of the supplier carried out on departure of the goods.' ],
'AEV' => [ 'Shipping note number',
    'Reference number assigned to a shipping note, see: 1001 = 630.' ],
'AEW' => [ 'Empty container bill number',
    'Reference number assigned to an empty container bill, see: 1001 = 708.' ],
'AEX' => [ 'Non-negotiable maritime transport document number',
    'Reference number assigned to a sea waybill, see: 1001 = 712.' ],
'AEY' => [ 'Substitute air waybill number',
    'Reference number assigned to a substitute air waybill, see: 1001 = 743.' ],
'AEZ' => [ 'Despatch note (post parcels) number',
    '(1128) Reference number assigned to a despatch note (post parcels), see: 1001 = 750.' ],
'AF' => [ 'Airlines flight identification number',
    '(8028) Identification of a commercial flight by carrier code and number as assigned by the airline (IATA).' ],
'AFA' => [ 'Through bill of lading number',
    'Reference number assigned to a through bill of lading, see: 1001 = 761.' ],
'AFB' => [ 'Cargo manifest number',
    'Reference number assigned to a cargo manifest, see: 1001 = 785.' ],
'AFC' => [ 'Bordereau number',
    'Reference number assigned to a bordereau, see: 1001 = 787.' ],
'AFD' => [ 'Customs item number',
    'Number (1496 in CST) assigned by the declarant to an item.' ],
'AFE' => [ 'Export Control Commodity number (ECCN)',
    'Reference number to relevant item within Commodity Control List covering actual products change functionality.' ],
'AFF' => [ 'Marking/label reference',
    'Reference where marking/label information derives from.' ],
'AFG' => [ 'Tariff number',
    'A number that identifies a tariff.' ],
'AFH' => [ 'Replenishment purchase order number',
    "Purchase order number specified by the buyer for the assignment to vendor's replenishment orders in a vendor managed inventory program." ],
'AFI' => [ 'Immediate transportation no. for in bond movement',
    'A number that identifies immediate transportation for in bond movement.' ],
'AFJ' => [ 'Transportation exportation no. for in bond movement',
    'A number that identifies the transportation exportation number for an in bond movement.' ],
'AFK' => [ 'Immediate exportation no. for in bond movement',
    'A number that identifies the immediate exportation number for an in bond movement.' ],
'AFL' => [ 'Associated invoices',
    'A number that identifies associated invoices.' ],
'AFM' => [ 'Secondary Customs reference',
    'A number that identifies the secondary customs reference.' ],
'AFN' => [ "Account party's reference",
    'Reference of the account party.' ],
'AFO' => [ "Beneficiary's reference",
    'Reference of the beneficiary.' ],
'AFP' => [ "Second beneficiary's reference",
    'Reference of the second beneficiary.' ],
'AFQ' => [ "Applicant's bank reference",
    "Reference number of the applicant's bank." ],
'AFR' => [ "Issuing bank's reference",
    'Reference number of the issuing bank.' ],
'AFS' => [ "Beneficiary's bank reference",
    "Reference number of the beneficiary's bank." ],
'AFT' => [ 'Direct payment valuation number',
    'Reference number assigned to a direct payment valuation.' ],
'AFU' => [ 'Direct payment valuation request number',
    'Reference number assigned to a direct payment valuation request.' ],
'AFV' => [ 'Quantity valuation number',
    'Reference number assigned to a quantity valuation.' ],
'AFW' => [ 'Quantity valuation request number',
    'Reference number assigned to a quantity valuation request.' ],
'AFX' => [ 'Bill of quantities number',
    'Reference number assigned to a bill of quantities.' ],
'AFY' => [ 'Payment valuation number',
    'Reference number assigned to a payment valuation.' ],
'AFZ' => [ 'Situation number',
    'Common reference number given to documents concerning a determined period of works.' ],
'AGA' => [ 'Agreement to pay number',
    'A number that identifies an agreement to pay.' ],
'AGB' => [ 'Contract party reference number',
    'Reference number assigned to a party for a particular contract.' ],
'AGC' => [ "Account party's bank reference",
    "Reference number of the account party's bank." ],
'AGD' => [ "Agent's bank reference",
    "Reference number issued by the agent's bank." ],
'AGE' => [ "Agent's reference",
    'Reference number of the agent.' ],
'AGF' => [ "Applicant's reference",
    'Reference number of the applicant.' ],
'AGG' => [ 'Dispute number',
    'Reference number to a dispute notice.' ],
'AGH' => [ "Credit rating agency's reference number",
    'Reference number assigned by a credit rating agency to a debtor.' ],
'AGI' => [ 'Request number',
    'The reference number of a request.' ],
'AGJ' => [ 'Single transaction sequence number',
    'A number that identifies a single transaction sequence.' ],
'AGK' => [ 'Application reference number',
    'A number that identifies an application reference.' ],
'AGL' => [ 'Delivery verification certificate',
    'Formal identification of delivery verification certificate which is a formal document from Customs etc. confirming that physical goods have been delivered. It may be needed to support a tax reclaim based on an invoice.' ],
'AGM' => [ 'Number of temporary importation document',
    'Number assigned by customs to identify consignment in transit.' ],
'AGN' => [ 'Reference number quoted on statement',
    'Reference number quoted on the statement sent to the beneficiary for information purposes.' ],
'AGO' => [ "Sender's reference to the original message",
    'The reference provided by the sender of the original message.' ],
'AGP' => [ 'Company issued equipment ID',
    'Owner/operator, non-government issued equipment reference number.' ],
'AGQ' => [ 'Domestic flight number',
    'Airline flight number assigned to a flight originating and terminating within the same country.' ],
'AGR' => [ 'International flight number',
    'Airline flight number assigned to a flight originating and terminating across national borders.' ],
'AGS' => [ 'Employer identification number of service bureau',
    'Reference number assigned by a service/processing bureau to an employer.' ],
'AGT' => [ 'Service group identification number',
    'Identification used for a group of services.' ],
'AGU' => [ 'Member number',
    'Reference number assigned to a person as a member of a group of persons or a service scheme.' ],
'AGV' => [ 'Previous member number',
    'Reference number previously assigned to a member.' ],
'AGW' => [ 'Scheme/plan number',
    'Reference number assigned to a service scheme or plan.' ],
'AGX' => [ 'Previous scheme/plan number',
    'Reference number previously assigned to a service scheme or plan.' ],
'AGY' => [ "Receiving party's member identification",
    'Identification used by the receiving party for a member of a service scheme or group of persons.' ],
'AGZ' => [ 'Payroll number',
    'Reference number assigned to the payroll of an organisation.' ],
'AHA' => [ 'Packaging specification number',
    'Reference number of documentation specifying the technical detail of packaging requirements.' ],
'AHB' => [ 'Authority issued equipment identification',
    'Identification issued by an authority, e.g. government, airport authority.' ],
'AHC' => [ 'Training flight number',
    'Non-revenue producing airline flight for training purposes.' ],
'AHD' => [ 'Fund code number',
    'Reference number to identify appropriation and branch chargeable for item.' ],
'AHE' => [ 'Signal code number',
    'Reference number to identify a signal.' ],
'AHF' => [ 'Major force program number',
    'Reference number according to Major Force Program (US).' ],
'AHG' => [ 'Nomination number',
    'Reference number assigned by a shipper to a request/ commitment-to-ship on a pipeline system.' ],
'AHH' => [ 'Laboratory registration number',
    'Reference number is the official registration number of the laboratory.' ],
'AHI' => [ 'Transport contract reference number',
    'Reference number of a transport contract.' ],
'AHJ' => [ "Payee's reference number",
    'Reference number of the party to be paid.' ],
'AHK' => [ "Payer's reference number",
    'Reference number of the party who pays.' ],
'AHL' => [ "Creditor's reference number",
    'Reference number of the party to whom a debt is owed.' ],
'AHM' => [ "Debtor's reference number",
    'Reference number of the party who owes an amount of money.' ],
'AHN' => [ 'Joint venture reference number',
    'Reference number assigned to a joint venture agreement.' ],
'AHO' => [ 'Chamber of Commerce registration number',
    'The registration number by which a company/organization is known to the Chamber of Commerce.' ],
'AHP' => [ 'Tax registration number',
    'The registration number by which a company/organization is identified with the tax administration.' ],
'AHQ' => [ 'Wool identification number',
    'Shipping Identification Mark (SIM) allocated to a wool consignment by a shipping company.' ],
'AHR' => [ 'Wool tax reference number',
    'Reference or indication of the payment of wool tax.' ],
'AHS' => [ 'Meat processing establishment registration number',
    'Registration number allocated to a registered meat packing establishment by the local quarantine and inspection authority.' ],
'AHT' => [ 'Quarantine/treatment status reference number',
    'Coded quarantine/treatment status of a container and its cargo and packing materials, generated by a shipping company based upon declarations presented by a shipper.' ],
'AHU' => [ 'Request for quote number',
    'Reference number assigned by the requestor to a request for quote.' ],
'AHV' => [ 'Manual processing authority number',
    'Number allocated to allow the manual processing of an entity.' ],
'AHX' => [ 'Rate note number',
    'Reference assigned to a specific rate.' ],
'AHY' => [ 'Freight Forwarder number',
    'An identification code of a Freight Forwarder.' ],
'AHZ' => [ 'Customs release code',
    'A code associated to a requirement that must be presented to gain the release of goods by Customs.' ],
'AIA' => [ 'Compliance code number',
    'Number assigned to indicate regulatory compliance.' ],
'AIB' => [ 'Department of transportation bond number',
    'Number of a bond assigned by the department of transportation.' ],
'AIC' => [ 'Export establishment number',
    'Number to identify export establishment.' ],
'AID' => [ 'Certificate of conformity',
    'Certificate certifying the conformity to predefined definitions.' ],
'AIE' => [ 'Ministerial certificate of homologation',
    'Certificate of approval for components which are subject to legal restrictions and must be approved by the government.' ],
'AIF' => [ 'Previous delivery instruction number',
    'The identification of a previous delivery instruction.' ],
'AIG' => [ 'Passport number',
    'Number assigned to a passport.' ],
'AIH' => [ 'Common transaction reference number',
    'Reference number applicable to different underlying individual transactions.' ],
'AII' => [ "Bank's common transaction reference number",
    "Bank's reference number allocated by the bank to different underlying individual transactions." ],
'AIJ' => [ "Customer's individual transaction reference number",
    "Customer's reference number allocated by the customer to one specific transaction." ],
'AIK' => [ "Bank's individual transaction reference number",
    "Bank's reference number allocated by the bank to one specific transaction." ],
'AIL' => [ "Customer's common transaction reference number",
    "Customer's reference number allocated by the customer to different underlying individual transactions." ],
'AIM' => [ 'Individual transaction reference number',
    'Reference number applying to one specific transaction.' ],
'AIN' => [ 'Product sourcing agreement number',
    'Reference number assigned to a product sourcing agreement.' ],
'AIO' => [ 'Customs transhipment number',
    'Approval number issued by Customs for cargo to be transhipped under Customs control.' ],
'AIP' => [ 'Customs preference inquiry number',
    'The number assigned by Customs to a preference inquiry.' ],
'AIQ' => [ 'Packing plant number',
    'Number to identify packing establishment.' ],
'AIR' => [ 'Original certificate number',
    'Number giving reference to an original certificate number.' ],
'AIS' => [ 'Processing plant number',
    'Number to identify processing plant.' ],
'AIT' => [ 'Slaughter plant number',
    'Number to identify slaughter plant.' ],
'AIU' => [ 'Charge card account number',
    'Number to identify charge card account.' ],
'AIV' => [ 'Event reference number',
    '[1007] Reference number identifying an event.' ],
'AIW' => [ 'Transport section reference number',
    'A number identifying a transport section.' ],
'AIX' => [ 'Referred product for mechanical analysis',
    'A product number identifying the product which is used for mechanical analysis considered valid for a group of products.' ],
'AIY' => [ 'Referred product for chemical analysis',
    'A product number identifying the product which is used for chemical analysis considered valid for a group of products.' ],
'AIZ' => [ 'Consolidated invoice number',
    'Invoice number into which other invoices are consolidated.' ],
'AJA' => [ 'Part reference indicator in a drawing',
    'To designate the number which provides a cross reference between parts contained in a drawing and a parts catalogue.' ],
'AJB' => [ 'U.S. Code of Federal Regulations (CFR)',
    'A reference indicating a citation from the U.S. Code of Federal Regulations (CFR).' ],
'AJC' => [ 'Purchasing activity clause number',
    'A number indicating a clause applicable to a purchasing activity.' ],
'AJD' => [ 'U.S. Defense Federal Acquisition Regulation Supplement',
    'A reference indicating a citation from the U.S. Defense Federal Acquisition Regulation Supplement.' ],
'AJE' => [ 'Agency clause number',
    'A number indicating a clause applicable to a particular agency.' ],
'AJF' => [ 'Circular publication number',
    'A number specifying a circular publication.' ],
'AJG' => [ 'U.S. Federal Acquisition Regulation',
    'A reference indicating a citation from the U.S. Federal Acquisition Regulation.' ],
'AJH' => [ 'U.S. General Services Administration Regulation',
    'A reference indicating a citation from U.S. General Services Administration Regulation.' ],
'AJI' => [ 'U.S. Federal Information Resources Management Regulation',
    'A reference indicating a citation from U.S. Federal Information Resources Management Regulation.' ],
'AJJ' => [ 'Paragraph',
    'A reference indicating a paragraph cited as the source of information.' ],
'AJK' => [ 'Special instructions number',
    'A number indicating a citation used for special instructions.' ],
'AJL' => [ 'Site specific procedures, terms, and conditions number',
    'A number indicating a set of site specific procedures, terms and conditions.' ],
'AJM' => [ 'Master solicitation procedures, terms, and conditions',
    'number A number indicating a master solicitation containing procedures, terms and conditions.' ],
'AJN' => [ 'U.S. Department of Veterans Affairs Acquisition Regulation',
    'A reference indicating a citation from the U.S. Department of Veterans Affairs Acquisition Regulation.' ],
'AJO' => [ 'Military Interdepartmental Purchase Request (MIPR) number',
    'A number indicating an interdepartmental purchase request used by the military.' ],
'AJP' => [ 'Foreign military sales number',
    'A number specifying a sale to a foreign military.' ],
'AJQ' => [ 'Defense priorities allocation system priority rating',
    'A reference indicating a priority rating assigned to allocate resources for defense purchases.' ],
'AJR' => [ 'Wage determination number',
    'A number specifying a wage determination.' ],
'AJS' => [ 'Agreement number',
    'A number specifying an agreement between parties.' ],
'AJT' => [ 'Standard Industry Classification (SIC) number',
    'A number specifying a standard industry classification.' ],
'AJU' => [ 'End item number',
    'A number specifying the end item applicable to a subordinate item.' ],
'AJV' => [ 'Federal supply schedule item number',
    'A number specifying an item listed in a federal supply schedule.' ],
'AJW' => [ 'Technical document number',
    'A number specifying a technical document.' ],
'AJX' => [ 'Technical order number',
    'A reference to an order that specifies a technical change.' ],
'AJY' => [ 'Suffix',
    'A reference to specify a suffix added to the end of a basic identifier.' ],
'AJZ' => [ 'Transportation account number',
    'An account number to be charged or credited for transportation.' ],
'AKA' => [ 'Container disposition order reference number',
    'Reference assigned to the empty container disposition order.' ],
'AKB' => [ 'Container prefix',
    'The first part of the unique identification of a container formed by an alpha code identifying the owner of the container.' ],
'AKC' => [ 'Transport equipment return reference',
    'Reference known at the address to return equipment to.' ],
'AKD' => [ 'Transport equipment survey reference',
    'Reference number assigned by the ordering party to the transport equipment survey order.' ],
'AKE' => [ 'Transport equipment survey report number',
    'Reference number used by a party to identify its transport equipment survey report.' ],
'AKF' => [ 'Transport equipment stuffing order',
    'Reference number assigned to the order to stuff goods in transport equipment.' ],
'AKG' => [ 'Vehicle Identification Number (VIN)',
    'The identification number which uniquely distinguishes one vehicle from another through the lifespan of the vehicle.' ],
'AKH' => [ 'Government bill of lading',
    'Bill of lading as defined by the government.' ],
'AKI' => [ "Ordering customer's second reference number",
    "Ordering customer's second reference number." ],
'AKJ' => [ 'Direct debit reference',
    'Reference number assigned to the direct debit operation.' ],
'AKK' => [ 'Meter reading at the beginning of the delivery',
    'Meter reading at the beginning of the delivery.' ],
'AKL' => [ 'Meter reading at the end of delivery',
    'Meter reading at the end of the delivery.' ],
'AKM' => [ 'Replenishment purchase order range start number',
    "Starting number of a range of purchase order numbers assigned by the buyer to vendor's replenishment orders." ],
'AKN' => [ "Third bank's reference",
    'Reference number of the third bank.' ],
'AKO' => [ 'Action authorization number',
    'A reference number authorizing an action.' ],
'AKP' => [ 'Appropriation number',
    'The number identifying a type of funding for a specific purpose (appropriation).' ],
'AKQ' => [ 'Product change authority number',
    'Number which authorises a change in form, fit or function of a product.' ],
'AKR' => [ 'General cargo consignment reference number',
    'Reference number identifying a particular general cargo (non-containerised or break bulk) consignment.' ],
'AKS' => [ 'Catalogue sequence number',
    'A number which uniquely identifies an item within a catalogue according to a standard numbering system.' ],
'AKT' => [ 'Forwarding order number',
    'Reference number assigned to the forwarding order by the ordering customer.' ],
'AKU' => [ 'Transport equipment survey reference number',
    'Reference number known at the address where the transport equipment will be or has been surveyed.' ],
'AKV' => [ 'Lease contract reference',
    'Reference number of the lease contract.' ],
'AKW' => [ 'Transport costs reference number',
    'Reference number of the transport costs.' ],
'AKX' => [ 'Transport equipment stripping order',
    'Reference number assigned to the order to strip goods from transport equipment.' ],
'AKY' => [ 'Prior policy number',
    'The number of the prior policy.' ],
'AKZ' => [ 'Policy number',
    'Number assigned to a policy.' ],
'ALA' => [ 'Procurement budget number',
    'A number which uniquely identifies a procurement budget against which commitments or invoices can be allocated.' ],
'ALB' => [ 'Domestic inventory management code',
    'Code to identify the management of domestic inventory.' ],
'ALC' => [ 'Customer reference number assigned to previous balance of',
    'payment information Identification number of the previous balance of payments information from customer message.' ],
'ALD' => [ 'Previous credit advice reference number',
    'Reference number of the previous "Credit advice" message.' ],
'ALE' => [ 'Reporting form number',
    'Reference number assigned to the reporting form.' ],
'ALF' => [ 'Authorization number for exception to dangerous goods',
    'regulations Reference number allocated by an authority. This number contains an approval concerning exceptions on the existing dangerous goods regulations.' ],
'ALG' => [ 'Dangerous goods security number',
    'Reference number allocated by an authority in order to control the dangerous goods on board of a specific means of transport for dangerous goods security purposes.' ],
'ALH' => [ 'Dangerous goods transport licence number',
    'Licence number allocated by an authority as to the permission of carrying dangerous goods by a specific means of transport.' ],
'ALI' => [ 'Previous rental agreement number',
    'Number to identify the previous rental agreement number.' ],
'ALJ' => [ 'Next rental agreement reason number',
    'Number to identify the reason for the next rental agreement.' ],
'ALK' => [ "Consignee's invoice number",
    'The invoice number assigned by a consignee.' ],
'ALL' => [ 'Message batch number',
    'A number identifying a batch of messages.' ],
'ALM' => [ 'Previous delivery schedule number',
    'A reference number identifying a previous delivery schedule.' ],
'ALN' => [ 'Physical inventory recount reference number',
    'A reference to a re-count of physically held inventory.' ],
'ALO' => [ 'Receiving advice number',
    'A reference number to a receiving advice.' ],
'ALP' => [ 'Returnable container reference number',
    'A reference number identifying a returnable container.' ],
'ALQ' => [ 'Returns notice number',
    'A reference number to a returns notice.' ],
'ALR' => [ 'Sales forecast number',
    'A reference number identifying a sales forecast.' ],
'ALS' => [ 'Sales report number',
    'A reference number identifying a sales report.' ],
'ALT' => [ 'Previous tax control number',
    'A reference number identifying a previous tax control number.' ],
'ALU' => [ 'AGERD (Aerospace Ground Equipment Requirement Data) number',
    'Identifies the equipment required to conduct maintenance.' ],
'ALV' => [ 'Registered capital reference',
    'Registered capital reference of a company.' ],
'ALW' => [ 'Standard number of inspection document',
    'Code identifying the standard number of the inspection document supplied.' ],
'ALX' => [ 'Model',
    'A reference used to identify a model.' ],
'ALY' => [ 'Financial management reference',
    'A financial management reference.' ],
'ALZ' => [ 'NOTIfication for COLlection number (NOTICOL)',
    'A reference assigned by a consignor to a notification document which indicates the availability of goods for collection.' ],
'AMA' => [ 'Previous request for metered reading reference number',
    'Number to identify a previous request for a recording or reading of a measuring device.' ],
'AMB' => [ 'Next rental agreement number',
    'Number to identify the next rental agreement.' ],
'AMC' => [ 'Reference number of a request for metered reading',
    'Number to identify a request for a recording or reading of a measuring device to be taken.' ],
'AMD' => [ 'Hastening number',
    'A number which uniquely identifies a request to hasten an action.' ],
'AME' => [ 'Repair data request number',
    'A number which uniquely identifies a request for data about repairs.' ],
'AMF' => [ 'Consumption data request number',
    'A number which identifies a request for consumption data.' ],
'AMG' => [ 'Profile number',
    'Reference number allocated to a discrete set of criteria.' ],
'AMH' => [ 'Case number',
    'Number assigned to a case.' ],
'AMI' => [ 'Government quality assurance and control level Number',
    'A number which identifies the level of quality assurance and control required by the government for an article.' ],
'AMJ' => [ 'Payment plan reference',
    'A number which uniquely identifies a payment plan.' ],
'AMK' => [ 'Replaced meter unit number',
    'Number identifying the replaced meter unit.' ],
'AML' => [ 'Replenishment purchase order range end number',
    "Ending number of a range of purchase order numbers assigned by the buyer to vendor's replenishment orders." ],
'AMM' => [ 'Insurer assigned reference number',
    'A unique reference number assigned by the insurer.' ],
'AMN' => [ 'Canadian excise entry number',
    'An excise entry number assigned by the Canadian Customs.' ],
'AMO' => [ 'Premium rate table',
    'Identifies the premium rate table.' ],
'AMP' => [ "Advise through bank's reference",
    'Financial institution through which the advising bank is to advise the documentary credit.' ],
'AMQ' => [ 'US, Department of Transportation bond surety code',
    'A bond surety code assigned by the United States Department of Transportation (DOT).' ],
'AMR' => [ 'US, Food and Drug Administration establishment indicator',
    'An establishment indicator assigned by the United States Food and Drug Administration.' ],
'AMS' => [ 'US, Federal Communications Commission (FCC) import',
    'condition number A number known as the United States Federal Communications Commission (FCC) import condition number applying to certain types of regulated communications equipment.' ],
'AMT' => [ 'Goods and Services Tax identification number',
    'An identification number assigned to an organization collecting Goods and Services Taxes (GST).' ],
'AMU' => [ 'Integrated logistic support cross reference number',
    'Provides the identification of the reference which allows cross referencing of items between different areas of integrated logistics support.' ],
'AMV' => [ 'Department number',
    'Number assigned to a department within an organization.' ],
'AMW' => [ "Buyer's catalogue number",
    'Identification of a catalogue maintained by a buyer.' ],
'AMX' => [ "Financial settlement party's reference number",
    'Reference number of the party who is responsible for the financial settlement.' ],
'AMY' => [ "Standard's version number",
    'The version number assigned to a standard.' ],
'AMZ' => [ 'Pipeline number',
    'Number to identify a pipeline.' ],
'ANA' => [ "Account servicing bank's reference number",
    'Reference number of the account servicing bank.' ],
'ANB' => [ 'Completed units payment request reference',
    'A reference to a payment request for completed units.' ],
'ANC' => [ 'Payment in advance request reference',
    'A reference to a request for payment in advance.' ],
'AND' => [ 'Parent file',
    'Identifies the parent file in a structure of related files.' ],
'ANE' => [ 'Sub file',
    'Identifies the sub file in a structure of related files.' ],
'ANF' => [ 'CAD file layer convention',
    'Reference number identifying a layer convention for a file in a Computer Aided Design (CAD) environment.' ],
'ANG' => [ 'Technical regulation',
    'Reference number identifying a technical regulation.' ],
'ANH' => [ 'Plot file',
    'Reference number indicating that the file is a plot file.' ],
'ANI' => [ 'File conversion journal',
    'Reference number identifying a journal recording details about conversion operations between file formats.' ],
'ANJ' => [ 'Authorization number',
    'A number which uniquely identifies an authorization.' ],
'ANK' => [ 'Reference number assigned by third party',
    'Reference number assigned by a third party.' ],
'ANL' => [ 'Deposit reference number',
    'A reference number identifying a deposit.' ],
'ANM' => [ "Named bank's reference",
    'Reference number of the named bank.' ],
'ANN' => [ "Drawee's reference",
    'Reference number of the drawee.' ],
'ANO' => [ "Case of need party's reference",
    'Reference number of the case of need party.' ],
'ANP' => [ "Collecting bank's reference",
    'Reference number of the collecting bank.' ],
'ANQ' => [ "Remitting bank's reference",
    'Reference number of the remitting bank.' ],
'ANR' => [ "Principal's bank reference",
    "Reference number of the principal's bank." ],
'ANS' => [ "Presenting bank's reference",
    'Reference number of the presenting bank.' ],
'ANT' => [ "Consignee's reference",
    'Reference number of the consignee.' ],
'ANU' => [ 'Financial transaction reference number',
    'Reference number of the financial transaction.' ],
'ANV' => [ 'Credit reference number',
    'The reference number of a credit instruction.' ],
'ANW' => [ "Receiving bank's authorization number",
    'Authorization number of the receiving bank.' ],
'ANX' => [ 'Clearing reference',
    'Reference allocated by a clearing procedure.' ],
'ANY' => [ "Sending bank's reference number",
    'Reference number of the sending bank.' ],
'AOA' => [ 'Documentary payment reference',
    'Reference of the documentary payment.' ],
'AOD' => [ 'Accounting file reference',
    'Reference of an accounting file.' ],
'AOE' => [ "Sender's file reference number",
    'File reference number assigned by the sender.' ],
'AOF' => [ "Receiver's file reference number",
    'File reference number assigned by the receiver.' ],
'AOG' => [ 'Source document internal reference',
    'Reference number assigned to a source document for internal usage.' ],
'AOH' => [ "Principal's reference",
    'Reference number of the principal.' ],
'AOI' => [ 'Debit reference number',
    'The reference number of a debit instruction.' ],
'AOJ' => [ 'Calendar',
    'A calendar reference number.' ],
'AOK' => [ 'Work shift',
    'A work shift reference number.' ],
'AOL' => [ 'Work breakdown structure',
    'A structure reference that identifies the breakdown of work for a project.' ],
'AOM' => [ 'Organisation breakdown structure',
    'A structure reference that identifies the breakdown of an organisation.' ],
'AON' => [ 'Work task charge number',
    'A reference assigned to a specific work task charge.' ],
'AOO' => [ 'Functional work group',
    'A reference to identify a functional group performing work.' ],
'AOP' => [ 'Work team',
    'A reference to identify a team performing work.' ],
'AOQ' => [ 'Department',
    'Section of an organisation.' ],
'AOR' => [ 'Statement of work',
    'A reference number for a statement of work.' ],
'AOS' => [ 'Work package',
    'A reference for a detailed package of work.' ],
'AOT' => [ 'Planning package',
    'A reference for a planning package of work.' ],
'AOU' => [ 'Cost account',
    'A cost control account reference.' ],
'AOV' => [ 'Work order',
    'Reference number for an order to do work.' ],
'AOW' => [ 'Transportation Control Number (TCN)',
    'A number assigned for transportation purposes.' ],
'AOX' => [ 'Constraint notation',
    'Identifies a reference to a constraint notation.' ],
'AOY' => [ 'ETERMS reference',
    'Identifies a reference to the ICC (International Chamber of Commerce) ETERMS(tm) repository of electronic commerce trading terms and conditions.' ],
'AOZ' => [ 'Implementation version number',
    'Identifies a version number of an implementation.' ],
'AP' => [ 'Accounts receivable number',
    'Reference number assigned by accounts receivable department to the account of a specific debtor.' ],
'APA' => [ 'Incorporated legal reference',
    'Identifies a legal reference which is deemed incorporated by reference.' ],
'APB' => [ 'Payment instalment reference number',
    'A reference number given to a payment instalment to identify a specific instance of payment of a debt which can be paid at specified intervals.' ],
'APC' => [ 'Equipment owner reference number',
    'Reference number issued by the owner of the equipment.' ],
'APD' => [ "Cedent's claim number",
    'To identify the number assigned to the claim by the ceding company.' ],
'APE' => [ "Reinsurer's claim number",
    'To identify the number assigned to the claim by the reinsurer.' ],
'APF' => [ 'Price/sales catalogue response reference number',
    'A reference number identifying a response to a price/sales catalogue.' ],
'APG' => [ 'General purpose message reference number',
    'A reference number identifying a general purpose message.' ],
'APH' => [ 'Invoicing data sheet reference number',
    'A reference number identifying an invoicing data sheet.' ],
'API' => [ 'Inventory report reference number',
    'A reference number identifying an inventory report.' ],
'APJ' => [ 'Ceiling formula reference number',
    'The reference number which identifies a formula for determining a ceiling.' ],
'APK' => [ 'Price variation formula reference number',
    'The reference number which identifies a price variation formula.' ],
'APL' => [ "Reference to account servicing bank's message",
    "Reference to the account servicing bank's message." ],
'APM' => [ 'Party sequence number',
    'Reference identifying a party sequence number.' ],
'APN' => [ "Purchaser's request reference",
    'Reference identifying a request made by the purchaser.' ],
'APO' => [ 'Contractor request reference',
    'Reference identifying a request made by a contractor.' ],
'APP' => [ 'Accident reference number',
    'Reference number assigned to an accident.' ],
'APQ' => [ 'Commercial account summary reference number',
    'A reference number identifying a commercial account summary.' ],
'APR' => [ 'Contract breakdown reference',
    'A reference which identifies a specific breakdown of a contract.' ],
'APS' => [ 'Contractor registration number',
    'A reference number used to identify a contractor.' ],
'APT' => [ 'Applicable coefficient identification number',
    'The identification number of the coefficient which is applicable.' ],
'APU' => [ 'Special budget account number',
    'The number of a special budget account.' ],
'APV' => [ 'Authorisation for repair reference',
    'Reference of the authorisation for repair.' ],
'APW' => [ 'Manufacturer defined repair rates reference',
    'Reference assigned by a manufacturer to their repair rates.' ],
'APX' => [ 'Original submitter log number',
    'A control number assigned by the original submitter.' ],
'APY' => [ 'Original submitter, parent Data Maintenance Request (DMR)',
    "log number A Data Maintenance Request (DMR) original submitter's reference log number for the parent DMR." ],
'APZ' => [ 'Original submitter, child Data Maintenance Request (DMR)',
    "log number A Data Maintenance Request (DMR) original submitter's reference log number for a child DMR." ],
'AQA' => [ 'Entry point assessment log number',
    'The reference log number assigned by an entry point assessment group for the DMR.' ],
'AQB' => [ 'Entry point assessment log number, parent DMR',
    'The reference log number assigned by an entry point assessment group for the parent Data Maintenance Request (DMR).' ],
'AQC' => [ 'Entry point assessment log number, child DMR',
    'The reference log number assigned by an entry point assessment group for a child Data Maintenance Request (DMR).' ],
'AQD' => [ 'Data structure tag',
    'The tag assigned to a data structure.' ],
'AQE' => [ 'Central secretariat log number',
    'The reference log number assigned by the central secretariat for the Data Maintenance Request (DMR).' ],
'AQF' => [ 'Central secretariat log number, parent Data Maintenance',
    'Request (DMR) The reference log number assigned by the central secretariat for the parent Data Maintenance Request (DMR).' ],
'AQG' => [ 'Central secretariat log number, child Data Maintenance',
    'Request (DMR) The reference log number assigned by the central secretariat for the child Data Maintenance Request (DMR).' ],
'AQH' => [ 'International assessment log number',
    'The reference log number assigned to a Data Maintenance Request (DMR) changed in international assessment.' ],
'AQI' => [ 'International assessment log number, parent Data',
    'Maintenance Request (DMR) The reference log number assigned to a Data Maintenance Request (DMR) changed in international assessment that is a parent to the current DMR.' ],
'AQJ' => [ 'International assessment log number, child Data Maintenance',
    'Request (DMR) The reference log number assigned to a Data Maintenance Request (DMR) changed in international assessment that is a child to the current DMR.' ],
'AQK' => [ 'Status report number',
    'The reference number for a status report.' ],
'AQL' => [ 'Message design group number',
    'Reference number for a message design group.' ],
'AQM' => [ 'US Customs Service (USCS) entry code',
    'An entry number assigned by the United States (US) customs service.' ],
'AQN' => [ 'Beginning job sequence number',
    'The number designating the beginning of the job sequence.' ],
'AQO' => [ "Sender's clause number",
    "The number that identifies the sender's clause." ],
'AQP' => [ "Dun and Bradstreet Canada's 8 digit Standard Industrial",
    "Classification (SIC) code Dun and Bradstreet Canada's 8 digit Standard Industrial Classification (SIC) code identifying activities of the company." ],
'AQQ' => [ 'Activite Principale Exercee (APE) identifier',
    'The French industry code for the main activity of a company.' ],
'AQR' => [ 'Dun and Bradstreet US 8 digit Standard Industrial',
    "Classification (SIC) code Dun and Bradstreet United States' 8 digit Standard Industrial Classification (SIC) code identifying activities of the company." ],
'AQS' => [ 'Nomenclature Activity Classification Economy (NACE)',
    'identifier A European industry classification code used to identify the activity of a company.' ],
'AQT' => [ 'Norme Activite Francaise (NAF) identifier',
    'A French industry classification code assigned by the French government to identify the activity of a company.' ],
'AQU' => [ 'Registered contractor activity type',
    'Reference number identifying the type of registered contractor activity.' ],
'AQV' => [ 'Statistic Bundes Amt (SBA) identifier',
    'A German industry classification code issued by Statistic Bundes Amt (SBA) to identify the activity of a company.' ],
'AQW' => [ 'State or province assigned entity identification',
    'Reference number of an entity assigned by a state or province.' ],
'AQX' => [ 'Institute of Security and Future Market Development (ISFMD)',
    'serial number A number used to identify a public but not publicly traded company.' ],
'AQY' => [ 'File identification number',
    'A number assigned to identify a file.' ],
'AQZ' => [ 'Bankruptcy procedure number',
    'A number identifying a bankruptcy procedure.' ],
'ARA' => [ 'National government business identification number',
    'A business identification number which is assigned by a national government.' ],
'ARB' => [ 'Prior Data Universal Number System (DUNS) number',
    'A previously assigned Data Universal Number System (DUNS) number.' ],
'ARC' => [ 'Companies Registry Office (CRO) number',
    'Identifies the reference number assigned by the Companies Registry Office (CRO).' ],
'ARD' => [ 'Costa Rican judicial number',
    'A number assigned by the government to a business in Costa Rica.' ],
'ARE' => [ 'Numero de Identificacion Tributaria (NIT)',
    'A number assigned by the government to a business in some Latin American countries.' ],
'ARF' => [ 'Patron number',
    'A number assigned by the government to a business in some Latin American countries. Note that "Patron" is a Spanish word, it is not a person who gives financial or other support.' ],
'ARG' => [ 'Registro Informacion Fiscal (RIF) number',
    'A number assigned by the government to a business in some Latin American countries.' ],
'ARH' => [ 'Registro Unico de Contribuyente (RUC) number',
    'A number assigned by the government to a business in some Latin American countries.' ],
'ARI' => [ 'Tokyo SHOKO Research (TSR) business identifier',
    'A number assigned to a business by TSR.' ],
'ARJ' => [ 'Personal identity card number',
    'An identity card number assigned to a person.' ],
'ARK' => [ 'Systeme Informatique pour le Repertoire des ENtreprises',
    '(SIREN) number An identification number known as a SIREN assigned to a business in France.' ],
'ARL' => [ 'Systeme Informatique pour le Repertoire des ETablissements',
    '(SIRET) number An identification number known as a SIRET assigned to a business location in France.' ],
'ARM' => [ 'Publication issue number',
    'A number assigned to identify a publication issue.' ],
'ARN' => [ 'Original filing number',
    'A number assigned to the original filing.' ],
'ARO' => [ 'Document page identifier',
    '[1212] To identify a page number.' ],
'ARP' => [ 'Public filing registration number',
    'A number assigned at the time of registration of a public filing.' ],
'ARQ' => [ 'Regiristo Federal de Contribuyentes',
    'A federal tax identification number assigned by the Mexican tax authority.' ],
'ARR' => [ 'Social security number',
    'An identification number assigned to an individual by the social security administration.' ],
'ARS' => [ 'Document volume number',
    'The number of a document volume.' ],
'ART' => [ 'Book number',
    'A number assigned to identify a book.' ],
'ARU' => [ 'Stock exchange company identifier',
    'A reference assigned by the stock exchange to a company.' ],
'ARV' => [ 'Imputation account',
    'An account to which an amount is to be posted.' ],
'ARW' => [ 'Financial phase reference',
    'A reference which identifies a specific financial phase.' ],
'ARX' => [ 'Technical phase reference',
    'A reference which identifies a specific technical phase.' ],
'ARY' => [ 'Prior contractor registration number',
    'A previous reference number used to identify a contractor.' ],
'ARZ' => [ 'Stock adjustment number',
    'A number identifying a stock adjustment.' ],
'ASA' => [ 'Dispensation reference',
    'A reference number assigned to an official exemption from a law or obligation.' ],
'ASB' => [ 'Investment reference number',
    'A reference to a specific investment.' ],
'ASC' => [ 'Assuming company',
    'A number that identifies an assuming company.' ],
'ASD' => [ 'Budget chapter',
    'A reference to the chapter in a budget.' ],
'ASE' => [ 'Duty free products security number',
    'A security number allocated for duty free products.' ],
'ASF' => [ 'Duty free products receipt authorisation number',
    'Authorisation number allocated for the receipt of duty free products.' ],
'ASG' => [ 'Party information message reference',
    'Reference identifying a party information message.' ],
'ASH' => [ 'Formal statement reference',
    'A reference to a formal statement.' ],
'ASI' => [ 'Proof of delivery reference number',
    'A reference number identifying a proof of delivery which is generated by the goods recipient.' ],
'ASJ' => [ "Supplier's credit claim reference number",
    "A reference number identifying a supplier's credit claim." ],
'ASK' => [ 'Picture of actual product',
    'Reference identifying the picture of an actual product.' ],
'ASL' => [ 'Picture of a generic product',
    'Reference identifying a picture of a generic product.' ],
'ASM' => [ 'Trading partner identification number',
    'Code specifying an identification assigned to an entity with whom one conducts trade.' ],
'ASN' => [ 'Prior trading partner identification number',
    'Code specifying an identification number previously assigned to a trading partner.' ],
'ASO' => [ 'Password',
    'Code used for authentication purposes.' ],
'ASP' => [ 'Formal report number',
    'A number uniquely identifying a formal report.' ],
'ASQ' => [ 'Fund account number',
    'Account number of fund.' ],
'ASR' => [ 'Safe custody number',
    'The number of a file or portfolio kept for safe custody on behalf of clients.' ],
'ASS' => [ 'Master account number',
    'A reference number identifying a master account.' ],
'AST' => [ 'Group reference number',
    'The reference number identifying a group.' ],
'ASU' => [ 'Accounting transmission number',
    'A number used to identify the transmission of an accounting book entry.' ],
'ASV' => [ 'Product data file number',
    'The number of a product data file.' ],
'ASW' => [ 'Cadastro Geral do Contribuinte (CGC)',
    'Brazilian taxpayer number.' ],
'ASX' => [ 'Foreign resident identification number',
    'Number assigned by a government agency to identify a foreign resident.' ],
'ASY' => [ 'CD-ROM',
    'Identity number of the Compact Disk Read Only Memory (CD-ROM).' ],
'ASZ' => [ 'Physical medium',
    'Identifies the physical medium.' ],
'ATA' => [ 'Financial cancellation reference number',
    'Reference number of a financial cancellation.' ],
'ATB' => [ 'Purchase for export Customs agreement number',
    'A number assigned by a Customs authority allowing the purchase of goods free of tax because they are to be exported immediately after the purchase.' ],
'ATC' => [ 'Judgment number',
    'A reference number identifying the legal decision.' ],
'ATD' => [ 'Secretariat number',
    'A reference number identifying a secretariat.' ],
'ATE' => [ 'Previous banking status message reference',
    'Message reference number of the previous banking status message being responded to.' ],
'ATF' => [ 'Last received banking status message reference',
    'Reference number of the latest received banking status message.' ],
'ATG' => [ "Bank's documentary procedure reference",
    'Reference allocated by the bank to a documentary procedure.' ],
'ATH' => [ "Customer's documentary procedure reference",
    'Reference allocated by a customer to a documentary procedure.' ],
'ATI' => [ 'Safe deposit box number',
    'Number of the safe deposit box.' ],
'ATJ' => [ 'Receiving Bankgiro number',
    'Number of the receiving Bankgiro.' ],
'ATK' => [ 'Sending Bankgiro number',
    'Number of the sending Bankgiro.' ],
'ATL' => [ 'Bankgiro reference',
    'Reference of the Bankgiro.' ],
'ATM' => [ 'Guarantee number',
    'Number of a guarantee.' ],
'ATN' => [ 'Collection instrument number',
    'To identify the number of an instrument used to remit funds to a beneficiary.' ],
'ATO' => [ 'Converted Postgiro number',
    'To identify the reference number of a giro payment having been converted to a Postgiro account.' ],
'ATP' => [ 'Cost centre alignment number',
    'Number used in the financial management process to align cost allocations.' ],
'ATQ' => [ 'Kamer Van Koophandel (KVK) number',
    'An identification number assigned by the Dutch Chamber of Commerce to a business in the Netherlands.' ],
'ATR' => [ 'Institut Belgo-Luxembourgeois de Codification (IBLC) number',
    'An identification number assigned by the Luxembourg National Bank to a business in Luxembourg.' ],
'ATS' => [ 'External object reference',
    'A reference identifying an external object.' ],
'ATT' => [ 'Exceptional transport authorisation number',
    'Authorisation number for exceptional transport (using specific equipment, out of gauge, materials and/or specific routing).' ],
'ATU' => [ 'Clave Unica de Identificacion Tributaria (CUIT)',
    'Tax identification number in Argentina.' ],
'ATV' => [ 'Registro Unico Tributario (RUT)',
    'Tax identification number in Chile.' ],
'ATW' => [ 'Flat rack container bundle identification number',
    'Reference number assigned to a bundle of flat rack containers.' ],
'ATX' => [ 'Transport equipment acceptance order reference',
    'Reference number assigned to an order to accept transport equipment that is to be delivered by an inland carrier to a specified facility.' ],
'ATY' => [ 'Transport equipment release order reference',
    'Reference number assigned to an order to release transport equipment which is to be picked up by an inland carrier from a specified facility.' ],
'ATZ' => [ "Ship's stay reference number",
    '(1099) Reference number assigned by a port authority to the stay of a vessel in the port.' ],
'AU' => [ 'Authorization to meet competition number',
    'A number assigned by a requestor to an offer incoming following request for quote.' ],
'AUA' => [ 'Place of positioning reference',
    'Identifies the reference pertaining to the place of positioning.' ],
'AUB' => [ 'Party reference',
    'The reference to a party.' ],
'AUC' => [ 'Issued prescription identification',
    'The identification of the issued prescription.' ],
'AUD' => [ 'Collection reference',
    'A reference identifying a collection.' ],
'AUE' => [ 'Travel service',
    'Reference identifying a travel service.' ],
'AUF' => [ 'Consignment stock contract',
    'Reference identifying a consignment stock contract.' ],
'AUG' => [ "Importer's letter of credit reference",
    'Letter of credit reference issued by importer.' ],
'AUH' => [ 'Performed prescription identification',
    'The identification of the prescription that has been carried into effect.' ],
'AUI' => [ 'Image reference',
    'A reference number identifying an image.' ],
'AUJ' => [ 'Proposed purchase order reference number',
    'A reference number assigned to a proposed purchase order.' ],
'AUK' => [ 'Application for financial support reference number',
    'Reference number assigned to an application for financial support.' ],
'AUL' => [ 'Manufacturing quality agreement number',
    'Reference number of a manufacturing quality agreement.' ],
'AUM' => [ 'Software editor reference',
    'Reference identifying the software editor.' ],
'AUN' => [ 'Software reference',
    'Reference identifying the software.' ],
'AUO' => [ 'Software quality reference',
    'Reference allocated to the software by a quality assurance agency.' ],
'AUP' => [ "Consolidated orders' reference",
    'A reference number to identify orders which have been, or shall be consolidated.' ],
'AUQ' => [ 'Customs binding ruling number',
    'Binding ruling number issued by customs.' ],
'AUR' => [ 'Customs non-binding ruling number',
    'Non-binding ruling number issued by customs.' ],
'AUS' => [ 'Delivery route reference',
    'A reference to the route of the delivery.' ],
'AUT' => [ 'Net area supplier reference',
    'A reference identifying a supplier within a net area.' ],
'AUU' => [ 'Time series reference',
    'Reference to a time series.' ],
'AUV' => [ 'Connecting point to central grid',
    'Reference to a connecting point to a central grid.' ],
'AUW' => [ 'Marketing plan identification number (MPIN)',
    'Number identifying a marketing plan.' ],
'AUX' => [ 'Entity reference number, previous',
    'The previous reference number assigned to an entity.' ],
'AUY' => [ 'International Standard Industrial Classification (ISIC)',
    'code A code specifying an international standard industrial classification.' ],
'AUZ' => [ 'Customs pre-approval ruling number',
    'Pre-approval ruling number issued by Customs.' ],
'AV' => [ 'Account payable number',
    'Reference number assigned by accounts payable department to the account of a specific creditor.' ],
'AVA' => [ "First financial institution's transaction reference",
    "Identifies the reference given to the individual transaction by the financial institution that is the transaction's point of entry into the interbank transaction chain." ],
'AVB' => [ 'Product characteristics directory',
    'A reference to a product characteristics directory.' ],
'AVC' => [ "Supplier's customer reference number",
    'A number, assigned by a supplier, to reference a customer.' ],
'AVD' => [ 'Inventory report request number',
    'Reference number assigned to a request for an inventory report.' ],
'AVE' => [ 'Metering point',
    'Reference to a metering point.' ],
'AVF' => [ 'Passenger reservation number',
    'Number assigned by the travel supplier to identify the passenger reservation.' ],
'AVG' => [ 'Slaughterhouse approval number',
    'Veterinary licence number allocated by a national authority to a slaughterhouse.' ],
'AVH' => [ 'Meat cutting plant approval number',
    'Veterinary licence number allocated by a national authority to a meat cutting plant.' ],
'AVI' => [ 'Customer travel service identifier',
    'A reference identifying a travel service to a customer.' ],
'AVJ' => [ 'Export control classification number',
    'Number identifying the classification of goods covered by an export licence.' ],
'AVK' => [ 'Broker reference 3',
    'Third reference of a broker.' ],
'AVL' => [ 'Consignment information',
    'Code identifying that the reference number given applies to the consignment information segment group in the referred message .' ],
'AVM' => [ 'Goods item information',
    'Code identifying that the reference number given applies to the goods item information segment group in the referred message.' ],
'AVN' => [ 'Dangerous Goods information',
    'Code identifying that the reference number given applies to the dangerous goods information segment group in the referred message.' ],
'AVO' => [ 'Pilotage services exemption number',
    'Number identifying the permit to not use pilotage services.' ],
'AVP' => [ 'Person registration number',
    'A number assigned to an individual.' ],
'AVQ' => [ 'Place of packing approval number',
    'Approval Number of the place where goods are packaged.' ],
'AVR' => [ 'Original Mandate Reference',
    'Reference to a specific related original mandate given by the relevant party for underlying business or action in case of reference or mandate change.' ],
'AVS' => [ 'Mandate Reference',
    'Reference to a specific mandate given by the relevant party for underlying business or action.' ],
'AVT' => [ 'Reservation station indentifier',
    'Reference to the station where a reservation was made.' ],
'AVU' => [ 'Unique goods shipment identifier',
    'Unique identifier assigned to a shipment of goods linking trade, tracking and transport information.' ],
'AVV' => [ 'Framework Agreement Number',
    'A reference to an agreement between one or more contracting authorities and one or more economic operators, the purpose of which is to establish the terms governing contracts to be awarded during a given period, in particular with regard to price and, where appropriate, the quantity envisaged.' ],
'AWA' => [ 'Rate code number',
    'Number assigned by a buyer to rate a product.' ],
'AWB' => [ 'Air waybill number',
    'Reference number assigned to an air waybill, see: 1001 = 740.' ],
'AWC' => [ 'Documentary credit amendment number',
    'Number of the amendment of the documentary credit.' ],
'AWD' => [ "Advising bank's reference",
    'Reference number of the advising bank.' ],
'AWE' => [ 'Cost centre',
    'A number identifying a cost centre.' ],
'AWF' => [ 'Work item quantity determination',
    'A reference assigned to a work item quantity determination.' ],
'AWG' => [ 'Internal data process number',
    'A number identifying an internal data process.' ],
'AWH' => [ 'Category of work reference',
    'A reference identifying a category of work.' ],
'AWI' => [ 'Policy form number',
    'Number assigned to a policy form.' ],
'AWJ' => [ 'Net area',
    'Reference to an area of a net.' ],
'AWK' => [ 'Service provider',
    'Reference of the service provider.' ],
'AWL' => [ 'Error position',
    'Reference to the position of an error in a message.' ],
'AWM' => [ 'Service category reference',
    'Reference identifying the service category.' ],
'AWN' => [ 'Connected location',
    'Reference of a connected location.' ],
'AWO' => [ 'Related party',
    'Reference of a related party.' ],
'AWP' => [ 'Latest accounting entry record reference',
    'Code identifying the reference of the latest accounting entry record.' ],
'AWQ' => [ 'Accounting entry',
    'Accounting entry to which this item is related.' ],
'AWR' => [ 'Document reference, original',
    'The original reference of a document.' ],
'AWS' => [ 'Hygienic Certificate number, national',
    'Nationally set Hygienic Certificate number, such as sanitary, epidemiologic.' ],
'BA' => [ 'Beginning meter reading actual',
    'Meter reading at the beginning of an invoicing period.' ],
'BC' => [ "Buyer's contract number",
    'Reference number assigned by buyer to a contract.' ],
'BD' => [ 'Bid number',
    'Number assigned by a submitter of a bid to his bid.' ],
'BE' => [ 'Beginning meter reading estimated',
    'Meter reading at the beginning of an invoicing period where an actual reading is not available.' ],
'BH' => [ 'House bill of lading number',
    'Reference number assigned to a house bill of lading, see: 1001 = 714.' ],
'BM' => [ 'Bill of lading number',
    'Reference number assigned to a bill of lading, see: 1001 = 705.' ],
'BN' => [ 'Consignment identifier, carrier assigned',
    '[1016] Reference number assigned by a carrier of its agent to identify a specific consignment such as a booking reference number when cargo space is reserved prior to loading.' ],
'BO' => [ 'Blanket order number',
    'Reference number assigned by the order issuer to a blanket order.' ],
'BR' => [ 'Broker or sales office number',
    'A number that identifies a broker or sales office.' ],
'BT' => [ 'Batch number/lot number',
    'Reference number assigned by manufacturer to a series of similar products or goods produced under similar conditions.' ],
'BW' => [ 'Blended with number',
    'The batch/lot/package number a product is blended with.' ],
'CAS' => [ 'IATA Cargo Agent CASS Address number',
    'Code issued by IATA to identify agent locations for CASS billing purposes.' ],
'CAT' => [ 'Matching of entries, balanced',
    'Reference to a balanced matching of entries.' ],
'CAU' => [ 'Entry flagging',
    'Reference to a flagging of entries.' ],
'CAV' => [ 'Matching of entries, unbalanced',
    'Reference to an unbalanced matching of entries.' ],
'CAW' => [ 'Document reference, internal',
    'Internal reference to a document.' ],
'CAX' => [ 'European Value Added Tax identification',
    'Value Added Tax identification number according to European regulation.' ],
'CAY' => [ 'Cost accounting document',
    'The reference to a cost accounting document.' ],
'CAZ' => [ "Grid operator's customer reference number",
    'A number, assigned by a grid operator, to reference a customer.' ],
'CBA' => [ 'Ticket control number',
    'Reference giving access to all the details associated with the ticket.' ],
'CD' => [ 'Credit note number',
    'Reference number assigned to a credit note.' ],
'CEC' => [ 'Ceding company',
    'Company selling obligations to a third party.' ],
'CFE' => [ "Consignee's further order",
    'Reference of an order given by the consignee after departure of the means of transport.' ],
'CFO' => [ "Consignor's further order",
    'Reference of an order given by the consignor after departure of the means of transport.' ],
'CG' => [ "Consignee's order number",
    "A number that identifies a consignee's order." ],
'CH' => [ 'Customer catalogue number',
    "Number identifying a catalogue for customer's usage." ],
'CK' => [ 'Cheque number',
    'Unique number assigned to one specific cheque.' ],
'CKN' => [ 'Checking number',
    'Number assigned by checking party to one specific check action.' ],
'CM' => [ 'Credit memo number',
    'Reference number assigned by issuer to a credit memo.' ],
'CMR' => [ 'Road consignment note number',
    'Reference number assigned to a road consignment note, see: 1001 = 730.' ],
'CN' => [ "Carrier's reference number",
    'Reference number assigned by carrier to a consignment.' ],
'CNO' => [ 'Charges note document attachment indicator',
    '[1070] Indication that a charges note has been established and attached to a transport contract document or not.' ],
'COF' => [ 'Call off order number',
    'A number that identifies a call off order.' ],
'CP' => [ 'Condition of purchase document number',
    'Reference number identifying the conditions of purchase relevant to a purchase.' ],
'CR' => [ 'Customer reference number',
    'Reference number assigned by the customer to a transaction.' ],
'CRN' => [ 'Transport means journey identifier',
    '[8028] To identify a journey of a means of transport, for example voyage number, flight number, trip number.' ],
'CS' => [ 'Condition of sale document number',
    'Reference number identifying the conditions of sale relevant to a sale.' ],
'CST' => [ 'Team assignment number',
    'Team number assigned to a group that is responsible for working a particular transaction.' ],
'CT' => [ 'Contract number',
    'Reference number of a contract concluded between parties.' ],
'CU' => [ 'Consignment identifier, consignor assigned',
    '[1140] Reference number assigned by the consignor to identify a particular consignment.' ],
'CV' => [ 'Container operators reference number',
    'Reference number assigned by the party operating or controlling the transport container to a transaction or consignment.' ],
'CW' => [ 'Package number',
    '(7070) Reference number identifying a package or carton within a consignment.' ],
'CZ' => [ 'Cooperation contract number',
    'Number issued by a party concerned given to a contract on cooperation of two or more parties.' ],
'DA' => [ 'Deferment approval number',
    'Number assigned by authorities to a party to approve deferment of payment of tax or duties.' ],
'DAN' => [ 'Debit account number',
    'Reference number assigned by issuer to a debit account.' ],
'DB' => [ "Buyer's debtor number",
    'Reference number assigned to a debtor.' ],
'DI' => [ 'Distributor invoice number',
    'Reference number assigned by issuer to a distributor invoice.' ],
'DL' => [ 'Debit note number',
    'Reference number assigned by issuer to a debit note.' ],
'DM' => [ 'Document identifier',
    '[1004] Reference number identifying a specific document.' ],
'DQ' => [ 'Delivery note number',
    'Reference number assigned by the issuer to a delivery note.' ],
'DR' => [ 'Dock receipt number',
    'Number of the cargo receipt submitted when cargo is delivered to a marine terminal.' ],
'EA' => [ 'Ending meter reading actual',
    'Meter reading at the end of an invoicing period.' ],
'EB' => [ 'Embargo permit number',
    'Reference number assigned by issuer to an embargo permit.' ],
'ED' => [ 'Export declaration',
    'Number assigned by the exporter to his export declaration number submitted to an authority.' ],
'EE' => [ 'Ending meter reading estimated',
    'Meter reading at the end of an invoicing period where an actual reading is not available.' ],
'EI' => [ "Employer's identification number",
    'Number issued by an authority to identify an employer.' ],
'EN' => [ 'Embargo number',
    'Number assigned to specific goods or a family of goods in a classification of embargo measures.' ],
'EQ' => [ 'Equipment number',
    'Number assigned by the manufacturer to specific equipment.' ],
'ER' => [ 'Container/equipment receipt number',
    'Number of the Equipment Interchange Receipt issued for full or empty equipment received.' ],
'ERN' => [ "Exporter's reference number",
    'Reference to a party exporting goods.' ],
'ET' => [ 'Excess transportation number',
    'Number assigned to excess transport.' ],
'EX' => [ 'Export permit identifier',
    '[1208] Reference number to identify an export licence or permit.' ],
'FC' => [ 'Fiscal number',
    "Tax payer's number. Number assigned to individual persons as well as to corporates by a public institution; this number is different from the VAT registration number." ],
'FF' => [ 'Consignment identifier, freight forwarder assigned',
    '[1460] Reference number assigned by the freight forwarder to identify a particular consignment.' ],
'FI' => [ 'File line identifier',
    'Number assigned by the file issuer or sender to identify a specific line.' ],
'FLW' => [ 'Flow reference number',
    'Number given to a usual sender which has regular expeditions of the same goods, to the same destination, defining all general conditions of the transport.' ],
'FN' => [ 'Freight bill number',
    'Reference number assigned by issuing party to a freight bill.' ],
'FO' => [ 'Foreign exchange',
    'Exchange of two currencies at an agreed rate.' ],
'FS' => [ 'Final sequence number',
    'A number that identifies the final sequence.' ],
'FT' => [ 'Free zone identifier',
    'Identifier to specify the territory of a State where any goods introduced are generally regarded, insofar as import duties and taxes are concerned, as being outside the Customs territory and are not subject to usual Customs control (CCC).' ],
'FV' => [ 'File version number',
    'Number given to a version of an identified file.' ],
'FX' => [ 'Foreign exchange contract number',
    'Reference number identifying a foreign exchange contract.' ],
'GA' => [ "Standard's number",
    'Number to identify a standardization description (e.g. ISO 9375).' ],
'GC' => [ 'Government contract number',
    'Number assigned to a specific government/public contract.' ],
'GD' => [ "Standard's code number",
    'Number to identify a specific parameter within a standardization description (e.g. M5 for screws or DIN A4 for paper).' ],
'GDN' => [ 'General declaration number',
    'Number of the declaration of incoming goods out of a vessel.' ],
'GN' => [ 'Government reference number',
    'A number that identifies a government reference.' ],
'HS' => [ 'Harmonised system number',
    'Number specifying the goods classification under the Harmonised Commodity Description and Coding System of the Customs Co-operation Council (CCC).' ],
'HWB' => [ 'House waybill number',
    'Reference number assigned to a house waybill, see: 1001 = 703.' ],
'IA' => [ 'Internal vendor number',
    'Number identifying the company-internal vending department/unit.' ],
'IB' => [ 'In bond number',
    'Customs assigned number that is used to control the movement of imported cargo prior to its formal Customs clearing.' ],
'ICA' => [ 'IATA cargo agent code number',
    'Code issued by IATA identify each IATA Cargo Agent whose name is entered on the Cargo Agency List.' ],
'ICE' => [ 'Insurance certificate reference number',
    'A number that identifies an insurance certificate reference.' ],
'ICO' => [ 'Insurance contract reference number',
    'A number that identifies an insurance contract reference.' ],
'II' => [ 'Initial sample inspection report number',
    'Inspection report number given to the initial sample inspection.' ],
'IL' => [ 'Internal order number',
    'Number assigned to an order for internal handling/follow up.' ],
'INB' => [ 'Intermediary broker',
    'A number that identifies an intermediary broker.' ],
'INN' => [ 'Interchange number new',
    'Number assigned by the interchange sender to identify one specific interchange. This number points to the actual interchange.' ],
'INO' => [ 'Interchange number old',
    'Number assigned by the interchange sender to identify one specific interchange. This number points to the previous interchange.' ],
'IP' => [ 'Import permit identifier',
    '[1107] Reference number to identify an import licence or permit.' ],
'IS' => [ 'Invoice number suffix',
    'A number added at the end of an invoice number.' ],
'IT' => [ 'Internal customer number',
    'Number assigned by a seller, supplier etc. to identify a customer within his enterprise.' ],
'IV' => [ 'Invoice document identifier',
    '[1334] Reference number to identify an invoice.' ],
'JB' => [ 'Job number',
    'Identifies a piece of work.' ],
'JE' => [ 'Ending job sequence number',
    'A number that identifies the ending job sequence.' ],
'LA' => [ 'Shipping label serial number',
    'The serial number on a shipping label.' ],
'LAN' => [ 'Loading authorisation identifier',
    '[4092] Identifier assigned to the loading authorisation granted by the forwarding location e.g. railway or airport, when the consignment is subject to traffic limitations.' ],
'LAR' => [ 'Lower number in range',
    'Lower number in a range of numbers.' ],
'LB' => [ 'Lockbox',
    "Type of cash management system offered by financial institutions to provide for collection of customers 'receivables'." ],
'LC' => [ 'Letter of credit number',
    'Reference number identifying the letter of credit document.' ],
'LI' => [ 'Document line identifier',
    '[1156] To identify a line of a document.' ],
'LO' => [ 'Load planning number',
    'The reference that identifies the load planning number.' ],
'LRC' => [ 'Reservation office identifier',
    'Reference to the office where a reservation was made.' ],
'LS' => [ 'Bar coded label serial number',
    'The serial number on a bar code label.' ],
'MA' => [ 'Ship notice/manifest number',
    'The number assigned to a ship notice or manifest.' ],
'MB' => [ 'Master bill of lading number',
    'Reference number assigned to a master bill of lading, see: 1001 = 704.' ],
'MF' => [ "Manufacturer's part number",
    'Reference number assigned by the manufacturer to his product or part.' ],
'MG' => [ 'Meter unit number',
    'Number identifying a unique meter unit.' ],
'MH' => [ 'Manufacturing order number',
    'Reference number assigned by manufacturer for a given production quantity of products.' ],
'MR' => [ 'Message recipient',
    'A number that identifies the message recipient.' ],
'MRN' => [ 'Mailing reference number',
    'Identifies the party designated by the importer to receive certain customs correspondence in lieu of its being mailed directly to the importer.' ],
'MS' => [ 'Message sender',
    'A number that identifies the message sender.' ],
'MSS' => [ "Manufacturer's material safety data sheet number",
    "A number that identifies a manufacturer's material safety data sheet." ],
'MWB' => [ 'Master air waybill number',
    'Reference number assigned to a master air waybill, see: 1001 = 741.' ],
'NA' => [ 'North American hazardous goods classification number',
    'Reference to materials designated as hazardous for purposes of transportation in North American commerce.' ],
'OH' => [ 'Current invoice number',
    'Reference number identifying the current invoice.' ],
'OI' => [ 'Previous invoice number',
    'Reference number identifying a previously issued invoice.' ],
'ON' => [ 'Order document identifier, buyer assigned',
    '[1022] Identifier assigned by the buyer to an order.' ],
'OP' => [ 'Original purchase order',
    'Reference to the order previously sent.' ],
'OR' => [ 'General order number',
    'Customs number assigned to imported merchandise that has been left unclaimed and subsequently moved to a Customs bonded warehouse for storage.' ],
'PB' => [ "Payer's financial institution account number",
    'Originated company account number (ACH transfer), check, draft or wire.' ],
'PC' => [ 'Production code',
    'Number assigned by the manufacturer to a specified article or batch to identify the manufacturing date etc. for subsequent reference.' ],
'PD' => [ 'Promotion deal number',
    'Number assigned by a vendor to a special promotion activity.' ],
'PE' => [ 'Plant number',
    'A number that identifies a plant.' ],
'PF' => [ 'Prime contractor contract number',
    'Reference number assigned by the client to the contract of the prime contractor.' ],
'PI' => [ 'Price list version number',
    'A number that identifies the version of a price list.' ],
'PK' => [ 'Packing list number',
    '(1014) Reference number assigned to a packing list, see: 1001 = 271.' ],
'PL' => [ 'Price list number',
    'Reference number assigned to a price list.' ],
'POR' => [ 'Purchase order response number',
    'Reference number assigned by the seller to an order response.' ],
'PP' => [ 'Purchase order change number',
    'Reference number assigned by a buyer for a revision of a purchase order.' ],
'PQ' => [ 'Payment reference',
    'Reference number assigned to a payment.' ],
'PR' => [ 'Price quote number',
    'Reference number assigned by the seller to a quote.' ],
'PS' => [ 'Purchase order number suffix',
    'A number added at the end of a purchase order number.' ],
'PW' => [ 'Prior purchase order number',
    'Reference number of a purchase order previously sent to the supplier.' ],
'PY' => [ "Payee's financial institution account number",
    'Receiving company account number (ACH transfer), check, draft or wire.' ],
'RA' => [ 'Remittance advice number',
    'A number that identifies a remittance advice.' ],
'RC' => [ 'Rail/road routing code',
    'International Western and Eastern European route code used in all rail organizations and specified in the international tariffs (rail tariffs) known by the customers.' ],
'RCN' => [ 'Railway consignment note number',
    'Reference number assigned to a rail consignment note, see: 1001 = 720.' ],
'RE' => [ 'Release number',
    'Reference number assigned to identify a release of a set of rules, conventions, conditions, etc.' ],
'REN' => [ 'Consignment receipt identifier',
    '[1150] Reference number assigned to identify a consignment upon its arrival at its destination.' ],
'RF' => [ 'Export reference number',
    'Reference number given to an export shipment.' ],
'RR' => [ "Payer's financial institution transit routing No.(ACH",
    'transfers) ODFI (ACH transfer).' ],
'RT' => [ "Payee's financial institution transit routing No.",
    'RDFI Transit routing number (ACH transfer).' ],
'SA' => [ 'Sales person number',
    'Identification number of a sales person.' ],
'SB' => [ 'Sales region number',
    'A number that identifies a sales region.' ],
'SD' => [ 'Sales department number',
    'A number that identifies a sales department.' ],
'SE' => [ 'Serial number',
    'Identification number of an item which distinguishes this specific item out of an number of identical items.' ],
'SF' => [ 'Ship from',
    'A number that identifies a ship from location.' ],
'SH' => [ 'Previous highest schedule number',
    'Number of the latest schedule of a previous period (ODETTE DELINS).' ],
'SI' => [ "SID (Shipper's identifying number for shipment)",
    "A number that identifies the SID (shipper's identification) number for a shipment." ],
'SM' => [ 'Sales office number',
    'A number that identifies a sales office.' ],
'SN' => [ 'Transport equipment seal identifier',
    '[9308] The identification number of a seal affixed to a piece of transport equipment.' ],
'SP' => [ 'Scan line',
    'A number that identifies a scan line.' ],
'SQ' => [ 'Equipment sequence number',
    'A temporary reference number identifying a particular piece of equipment within a series of pieces of equipment.' ],
'SRN' => [ 'Shipment reference number',
    'Reference number assigned to a shipment.' ],
'SS' => [ 'Sellers reference number',
    'Reference number assigned to a transaction by the seller.' ],
'STA' => [ 'Station reference number',
    'International UIC code assigned to every European rail station (CIM convention).' ],
'SW' => [ 'Swap order number',
    'Number assigned by the seller to a swap order (see definition of DE 1001, code 229).' ],
'SZ' => [ 'Specification number',
    'Number assigned by the issuer to his specification.' ],
'TB' => [ "Trucker's bill of lading",
    'A cargo list/description issued by a motor carrier of freight.' ],
'TCR' => [ "Terminal operator's consignment reference",
    'Reference assigned to a consignment by the terminal operator.' ],
'TE' => [ 'Telex message number',
    'Reference number identifying a telex message.' ],
'TF' => [ 'Transfer number',
    'An extra number assigned to goods or a container which functions as a reference number or as an authorization number to get the goods or container released from a certain party.' ],
'TI' => [ 'TIR carnet number',
    'Reference number assigned to a TIR carnet.' ],
'TIN' => [ 'Transport instruction number',
    'Reference number identifying a transport instruction.' ],
'TL' => [ 'Tax exemption licence number',
    'Number assigned by the tax authorities to a party indicating its tax exemption authorization. This number could relate to a specified business type, a specified local area or a class of products.' ],
'TN' => [ 'Transaction reference number',
    'Reference applied to a transaction between two or more parties over a defined life cycle; e.g. number applied by importer or broker to obtain release from Customs, may then used to control declaration through final accounting (synonyms: declaration, entry number).' ],
'TP' => [ 'Test report number',
    'Reference number identifying a test report document relevant to the product.' ],
'UAR' => [ 'Upper number of range',
    'Upper number in a range of numbers.' ],
'UC' => [ "Ultimate customer's reference number",
    "The originator's reference number as forwarded in a sequence of parties involved." ],
'UCN' => [ 'Unique consignment reference number',
    '[1202] Unique reference identifying a particular consignment of goods. Synonym: UCR, UCRN.' ],
'UN' => [ 'United Nations Dangerous Goods identifier',
    '[7124] United Nations Dangerous Goods Identifier (UNDG) is the unique serial number assigned within the United Nations to substances and articles contained in a list of the dangerous goods most commonly carried.' ],
'UO' => [ "Ultimate customer's order number",
    "The originator's order number as forwarded in a sequence of parties involved." ],
'VA' => [ 'VAT registration number',
    'Unique number assigned by the relevant tax authority to identify a party for use in relation to Value Added Tax (VAT).' ],
'VC' => [ 'Vendor contract number',
    'Number assigned by the vendor to a contract.' ],
'VM' => [ 'Vessel identifier',
    '(8123) Reference identifying a vessel.' ],
'VN' => [ 'Order number (vendor)',
    "Reference number assigned by supplier to a buyer's purchase order." ],
'VON' => [ 'Voyage number',
    '(8028) Reference number assigned to the voyage of the vessel.' ],
'VP' => [ 'Vendor product number',
    "Number assigned by vendor to another manufacturer's product." ],
'VR' => [ 'Vendor ID number',
    "A number that identifies a vendor's identification." ],
'VS' => [ 'Vendor order number suffix',
    'The suffix for a vendor order number.' ],
'VT' => [ 'Motor vehicle identification number',
    '(8213) Reference identifying a motor vehicle used for transport. Normally is the vehicle registration number.' ],
'VV' => [ 'Voucher number',
    'Reference number identifying a voucher.' ],
'WE' => [ 'Warehouse entry number',
    'Entry number under which imported merchandise was placed in a Customs bonded warehouse.' ],
'WM' => [ 'Weight agreement number',
    'A number identifying a weight agreement.' ],
'WN' => [ 'Well number',
    'A number assigned to a shaft sunk into the ground.' ],
'WR' => [ 'Warehouse receipt number',
    'A number identifying a warehouse receipt.' ],
'WS' => [ 'Warehouse storage location number',
    'A number identifying a warehouse storage location.' ],
'WY' => [ 'Rail waybill number',
    'The number on a rail waybill.' ],
'XA' => [ 'Company/place registration number',
    'Company registration and place as legally required.' ],
'XC' => [ 'Cargo control number',
    'Reference used to identify and control a carrier and consignment from initial entry into a country until release of the cargo by Customs.' ],
'XP' => [ 'Previous cargo control number',
    'Where a consignment is deconsolidated and/or transferred to the control of another carrier or freight forwarder (e.g. housebill, abstract) this references the previous (e.g. master) cargo control number.' ],
'ZZZ' => [ 'Mutually defined reference number',
    'Number based on party agreement.' ],
);
sub get_codes { return \%code_hash; }

1;
