How to become a contributor and submit patches
==============================================

Contributor License Agreements
------------------------------
We'd love to accept your code patches! However, before we can take them, we have to clear a couple of legal hurdles.

Please fill out either the individual or corporate Contributor License Agreement.

* If you are an individual writing original source code and you're sure you own the intellectual property, then you'll need to sign an individual CLA available at <http://code.google.com/legal/individual-cla-v1.0.html>.
* If you work for a company that wants to allow you to contribute your work to this client library, then you'll need to sign a corporate CLA available at <http://code.google.com/legal/corporate-cla-v1.0.html>.

Follow either of the two links above to access the appropriate CLA and instructions for how to sign and return it. Once we receive it, we'll add you to the official list of contributors and be able to accept your patches.

Submitting Patches
------------------
1. Sign a Contributor License Agreement (see above).
1. Join the [AdWords API discussion group](http://groups.google.com/group/adwords-api).
1. Create an issue on the library issue tracker if there isn't one already. Use this issue to co-ordinate the changes with the library maintainer.
1. Fork the library, make the changes and send a [pull request](https://help.github.com/articles/using-pull-requests).
1. The library maintainer will work with you to review and apply the patch.

If you can't become a contributor
---------------------------------
If you can't become a contributor, but wish to share some code that illustrates an issue / shows how an issue may be fixed, then you can attach your changes on the issue tracker. We will use this code to troubleshoot the issue and fix it, but will not use this code in the library unless the steps to submit patches are done.
