# Generated by default/object.tt
package Paws::AccessAnalyzer::AccessPreviewFinding;
  use Moose;
  has Action => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'action', traits => ['NameInRequest']);
  has ChangeType => (is => 'ro', isa => 'Str', request_name => 'changeType', traits => ['NameInRequest'], required => 1);
  has Condition => (is => 'ro', isa => 'Paws::AccessAnalyzer::ConditionKeyMap', request_name => 'condition', traits => ['NameInRequest']);
  has CreatedAt => (is => 'ro', isa => 'Str', request_name => 'createdAt', traits => ['NameInRequest'], required => 1);
  has Error => (is => 'ro', isa => 'Str', request_name => 'error', traits => ['NameInRequest']);
  has ExistingFindingId => (is => 'ro', isa => 'Str', request_name => 'existingFindingId', traits => ['NameInRequest']);
  has ExistingFindingStatus => (is => 'ro', isa => 'Str', request_name => 'existingFindingStatus', traits => ['NameInRequest']);
  has Id => (is => 'ro', isa => 'Str', request_name => 'id', traits => ['NameInRequest'], required => 1);
  has IsPublic => (is => 'ro', isa => 'Bool', request_name => 'isPublic', traits => ['NameInRequest']);
  has Principal => (is => 'ro', isa => 'Paws::AccessAnalyzer::PrincipalMap', request_name => 'principal', traits => ['NameInRequest']);
  has Resource => (is => 'ro', isa => 'Str', request_name => 'resource', traits => ['NameInRequest']);
  has ResourceOwnerAccount => (is => 'ro', isa => 'Str', request_name => 'resourceOwnerAccount', traits => ['NameInRequest'], required => 1);
  has ResourceType => (is => 'ro', isa => 'Str', request_name => 'resourceType', traits => ['NameInRequest'], required => 1);
  has Sources => (is => 'ro', isa => 'ArrayRef[Paws::AccessAnalyzer::FindingSource]', request_name => 'sources', traits => ['NameInRequest']);
  has Status => (is => 'ro', isa => 'Str', request_name => 'status', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AccessAnalyzer::AccessPreviewFinding

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AccessAnalyzer::AccessPreviewFinding object:

  $service_obj->Method(Att1 => { Action => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AccessAnalyzer::AccessPreviewFinding object:

  $result = $service_obj->Method(...);
  $result->Att1->Action

=head1 DESCRIPTION

An access preview finding generated by the access preview.

=head1 ATTRIBUTES


=head2 Action => ArrayRef[Str|Undef]

The action in the analyzed policy statement that an external principal
has permission to perform.


=head2 B<REQUIRED> ChangeType => Str

Provides context on how the access preview finding compares to existing
access identified in Access Analyzer.

=over

=item *

C<New> - The finding is for newly-introduced access.

=item *

C<Unchanged> - The preview finding is an existing finding that would
remain unchanged.

=item *

C<Changed> - The preview finding is an existing finding with a change
in status.

=back

For example, a C<Changed> finding with preview status C<Resolved> and
existing status C<Active> indicates the existing C<Active> finding
would become C<Resolved> as a result of the proposed permissions
change.


=head2 Condition => L<Paws::AccessAnalyzer::ConditionKeyMap>

The condition in the analyzed policy statement that resulted in a
finding.


=head2 B<REQUIRED> CreatedAt => Str

The time at which the access preview finding was created.


=head2 Error => Str

An error.


=head2 ExistingFindingId => Str

The existing ID of the finding in Access Analyzer, provided only for
existing findings.


=head2 ExistingFindingStatus => Str

The existing status of the finding, provided only for existing
findings.


=head2 B<REQUIRED> Id => Str

The ID of the access preview finding. This ID uniquely identifies the
element in the list of access preview findings and is not related to
the finding ID in Access Analyzer.


=head2 IsPublic => Bool

Indicates whether the policy that generated the finding allows public
access to the resource.


=head2 Principal => L<Paws::AccessAnalyzer::PrincipalMap>

The external principal that has access to a resource within the zone of
trust.


=head2 Resource => Str

The resource that an external principal has access to. This is the
resource associated with the access preview.


=head2 B<REQUIRED> ResourceOwnerAccount => Str

The AWS account ID that owns the resource. For most AWS resources, the
owning account is the account in which the resource was created.


=head2 B<REQUIRED> ResourceType => Str

The type of the resource that can be accessed in the finding.


=head2 Sources => ArrayRef[L<Paws::AccessAnalyzer::FindingSource>]

The sources of the finding. This indicates how the access that
generated the finding is granted. It is populated for Amazon S3 bucket
findings.


=head2 B<REQUIRED> Status => Str

The preview status of the finding. This is what the status of the
finding would be after permissions deployment. For example, a
C<Changed> finding with preview status C<Resolved> and existing status
C<Active> indicates the existing C<Active> finding would become
C<Resolved> as a result of the proposed permissions change.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AccessAnalyzer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

