# Generated by default/object.tt
package Paws::AmplifyBackend::LoginAuthConfigReqObj;
  use Moose;
  has AwsCognitoIdentityPoolId => (is => 'ro', isa => 'Str', request_name => 'aws_cognito_identity_pool_id', traits => ['NameInRequest']);
  has AwsCognitoRegion => (is => 'ro', isa => 'Str', request_name => 'aws_cognito_region', traits => ['NameInRequest']);
  has AwsUserPoolsId => (is => 'ro', isa => 'Str', request_name => 'aws_user_pools_id', traits => ['NameInRequest']);
  has AwsUserPoolsWebClientId => (is => 'ro', isa => 'Str', request_name => 'aws_user_pools_web_client_id', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AmplifyBackend::LoginAuthConfigReqObj

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AmplifyBackend::LoginAuthConfigReqObj object:

  $service_obj->Method(Att1 => { AwsCognitoIdentityPoolId => $value, ..., AwsUserPoolsWebClientId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AmplifyBackend::LoginAuthConfigReqObj object:

  $result = $service_obj->Method(...);
  $result->Att1->AwsCognitoIdentityPoolId

=head1 DESCRIPTION

The request object for this operation.

=head1 ATTRIBUTES


=head2 AwsCognitoIdentityPoolId => Str

The Amazon Cognito identity pool ID used for the Amplify Admin UI login
authorization.


=head2 AwsCognitoRegion => Str

The AWS Region for the Amplify Admin UI login.


=head2 AwsUserPoolsId => Str

The Amazon Cognito user pool ID used for Amplify Admin UI login
authentication.


=head2 AwsUserPoolsWebClientId => Str

The web client ID for the Amazon Cognito user pools.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AmplifyBackend>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

