# Generated by default/object.tt
package Paws::AppConfig::DeploymentEvent;
  use Moose;
  has Description => (is => 'ro', isa => 'Str');
  has EventType => (is => 'ro', isa => 'Str');
  has OccurredAt => (is => 'ro', isa => 'Str');
  has TriggeredBy => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::AppConfig::DeploymentEvent

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AppConfig::DeploymentEvent object:

  $service_obj->Method(Att1 => { Description => $value, ..., TriggeredBy => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AppConfig::DeploymentEvent object:

  $result = $service_obj->Method(...);
  $result->Att1->Description

=head1 DESCRIPTION

An object that describes a deployment event.

=head1 ATTRIBUTES


=head2 Description => Str

A description of the deployment event. Descriptions include, but are
not limited to, the user account or the CloudWatch alarm ARN that
initiated a rollback, the percentage of hosts that received the
deployment, or in the case of an internal error, a recommendation to
attempt a new deployment.


=head2 EventType => Str

The type of deployment event. Deployment event types include the start,
stop, or completion of a deployment; a percentage update; the start or
stop of a bake period; the start or completion of a rollback.


=head2 OccurredAt => Str

The date and time the event occurred.


=head2 TriggeredBy => Str

The entity that triggered the deployment event. Events can be triggered
by a user, AWS AppConfig, an Amazon CloudWatch alarm, or an internal
error.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AppConfig>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

