# Generated by default/object.tt
package Paws::AuditManager::CreateDelegationRequest;
  use Moose;
  has Comment => (is => 'ro', isa => 'Str', request_name => 'comment', traits => ['NameInRequest']);
  has ControlSetId => (is => 'ro', isa => 'Str', request_name => 'controlSetId', traits => ['NameInRequest']);
  has RoleArn => (is => 'ro', isa => 'Str', request_name => 'roleArn', traits => ['NameInRequest']);
  has RoleType => (is => 'ro', isa => 'Str', request_name => 'roleType', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AuditManager::CreateDelegationRequest

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AuditManager::CreateDelegationRequest object:

  $service_obj->Method(Att1 => { Comment => $value, ..., RoleType => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AuditManager::CreateDelegationRequest object:

  $result = $service_obj->Method(...);
  $result->Att1->Comment

=head1 DESCRIPTION

A collection of attributes used to create a delegation for an
assessment in AWS Audit Manager.

=head1 ATTRIBUTES


=head2 Comment => Str

A comment related to the delegation request.


=head2 ControlSetId => Str

The unique identifier for the control set.


=head2 RoleArn => Str

The Amazon Resource Name (ARN) of the IAM role.


=head2 RoleType => Str

The type of customer persona.

In C<CreateAssessment>, C<roleType> can only be C<PROCESS_OWNER>.

In C<UpdateSettings>, C<roleType> can only be C<PROCESS_OWNER>.

In C<BatchCreateDelegationByAssessment>, C<roleType> can only be
C<RESOURCE_OWNER>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AuditManager>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

