# Generated by default/object.tt
package Paws::ComputeOptimizer::VolumeRecommendation;
  use Moose;
  has AccountId => (is => 'ro', isa => 'Str', request_name => 'accountId', traits => ['NameInRequest']);
  has CurrentConfiguration => (is => 'ro', isa => 'Paws::ComputeOptimizer::VolumeConfiguration', request_name => 'currentConfiguration', traits => ['NameInRequest']);
  has Finding => (is => 'ro', isa => 'Str', request_name => 'finding', traits => ['NameInRequest']);
  has LastRefreshTimestamp => (is => 'ro', isa => 'Str', request_name => 'lastRefreshTimestamp', traits => ['NameInRequest']);
  has LookBackPeriodInDays => (is => 'ro', isa => 'Num', request_name => 'lookBackPeriodInDays', traits => ['NameInRequest']);
  has UtilizationMetrics => (is => 'ro', isa => 'ArrayRef[Paws::ComputeOptimizer::EBSUtilizationMetric]', request_name => 'utilizationMetrics', traits => ['NameInRequest']);
  has VolumeArn => (is => 'ro', isa => 'Str', request_name => 'volumeArn', traits => ['NameInRequest']);
  has VolumeRecommendationOptions => (is => 'ro', isa => 'ArrayRef[Paws::ComputeOptimizer::VolumeRecommendationOption]', request_name => 'volumeRecommendationOptions', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ComputeOptimizer::VolumeRecommendation

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ComputeOptimizer::VolumeRecommendation object:

  $service_obj->Method(Att1 => { AccountId => $value, ..., VolumeRecommendationOptions => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ComputeOptimizer::VolumeRecommendation object:

  $result = $service_obj->Method(...);
  $result->Att1->AccountId

=head1 DESCRIPTION

Describes an Amazon Elastic Block Store (Amazon EBS) volume
recommendation.

=head1 ATTRIBUTES


=head2 AccountId => Str

The AWS account ID of the volume.


=head2 CurrentConfiguration => L<Paws::ComputeOptimizer::VolumeConfiguration>

An array of objects that describe the current configuration of the
volume.


=head2 Finding => Str

The finding classification of the volume.

Findings for volumes include:

=over

=item *

B<C<NotOptimized> >E<mdash>A volume is considered not optimized when
AWS Compute Optimizer identifies a recommendation that can provide
better performance for your workload.

=item *

B<C<Optimized> >E<mdash>An volume is considered optimized when Compute
Optimizer determines that the volume is correctly provisioned to run
your workload based on the chosen volume type. For optimized resources,
Compute Optimizer might recommend a new generation volume type.

=back



=head2 LastRefreshTimestamp => Str

The time stamp of when the volume recommendation was last refreshed.


=head2 LookBackPeriodInDays => Num

The number of days for which utilization metrics were analyzed for the
volume.


=head2 UtilizationMetrics => ArrayRef[L<Paws::ComputeOptimizer::EBSUtilizationMetric>]

An array of objects that describe the utilization metrics of the
volume.


=head2 VolumeArn => Str

The Amazon Resource Name (ARN) of the current volume.


=head2 VolumeRecommendationOptions => ArrayRef[L<Paws::ComputeOptimizer::VolumeRecommendationOption>]

An array of objects that describe the recommendation options for the
volume.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ComputeOptimizer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

