# Generated by default/object.tt
package Paws::FIS::ExperimentSummary;
  use Moose;
  has CreationTime => (is => 'ro', isa => 'Str', request_name => 'creationTime', traits => ['NameInRequest']);
  has ExperimentTemplateId => (is => 'ro', isa => 'Str', request_name => 'experimentTemplateId', traits => ['NameInRequest']);
  has Id => (is => 'ro', isa => 'Str', request_name => 'id', traits => ['NameInRequest']);
  has State => (is => 'ro', isa => 'Paws::FIS::ExperimentState', request_name => 'state', traits => ['NameInRequest']);
  has Tags => (is => 'ro', isa => 'Paws::FIS::TagMap', request_name => 'tags', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::FIS::ExperimentSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::FIS::ExperimentSummary object:

  $service_obj->Method(Att1 => { CreationTime => $value, ..., Tags => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::FIS::ExperimentSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->CreationTime

=head1 DESCRIPTION

Provides a summary of an experiment.

=head1 ATTRIBUTES


=head2 CreationTime => Str

The time that the experiment was created.


=head2 ExperimentTemplateId => Str

The ID of the experiment template.


=head2 Id => Str

The ID of the experiment.


=head2 State => L<Paws::FIS::ExperimentState>

The state of the experiment.


=head2 Tags => L<Paws::FIS::TagMap>

The tags for the experiment.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::FIS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

