# Generated by default/object.tt
package Paws::GameLift::EC2InstanceLimit;
  use Moose;
  has CurrentInstances => (is => 'ro', isa => 'Int');
  has EC2InstanceType => (is => 'ro', isa => 'Str');
  has InstanceLimit => (is => 'ro', isa => 'Int');
  has Location => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::GameLift::EC2InstanceLimit

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GameLift::EC2InstanceLimit object:

  $service_obj->Method(Att1 => { CurrentInstances => $value, ..., Location => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GameLift::EC2InstanceLimit object:

  $result = $service_obj->Method(...);
  $result->Att1->CurrentInstances

=head1 DESCRIPTION

The GameLift service limits for an EC2 instance type and current
utilization. GameLift allows AWS accounts a maximum number of
instances, per instance type, per AWS Region or location, for use with
GameLift. You can request an limit increase for your account by using
the B<Service limits> page in the GameLift console.

B<Related actions>

DescribeEC2InstanceLimits

=head1 ATTRIBUTES


=head2 CurrentInstances => Int

The number of instances for the specified type and location that are
currently being used by the AWS account.


=head2 EC2InstanceType => Str

The name of an EC2 instance type. See Amazon EC2 Instance Types
(http://aws.amazon.com/ec2/instance-types/) for detailed descriptions.


=head2 InstanceLimit => Int

The number of instances that is allowed for the specified instance type
and location.


=head2 Location => Str

An AWS Region code, such as C<us-west-2>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GameLift>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

