# Generated by default/object.tt
package Paws::GlobalAccelerator::ByoipCidr;
  use Moose;
  has Cidr => (is => 'ro', isa => 'Str');
  has Events => (is => 'ro', isa => 'ArrayRef[Paws::GlobalAccelerator::ByoipCidrEvent]');
  has State => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::GlobalAccelerator::ByoipCidr

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GlobalAccelerator::ByoipCidr object:

  $service_obj->Method(Att1 => { Cidr => $value, ..., State => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GlobalAccelerator::ByoipCidr object:

  $result = $service_obj->Method(...);
  $result->Att1->Cidr

=head1 DESCRIPTION

Information about an IP address range that is provisioned for use with
your AWS resources through bring your own IP address (BYOIP).

The following describes each BYOIP C<State> that your IP address range
can be in.

=over

=item *

B<PENDING_PROVISIONING> E<mdash> YouE<rsquo>ve submitted a request to
provision an IP address range but it is not yet provisioned with AWS
Global Accelerator.

=item *

B<READY> E<mdash> The address range is provisioned with AWS Global
Accelerator and can be advertised.

=item *

B<PENDING_ADVERTISING> E<mdash> YouE<rsquo>ve submitted a request for
AWS Global Accelerator to advertise an address range but it is not yet
being advertised.

=item *

B<ADVERTISING> E<mdash> The address range is being advertised by AWS
Global Accelerator.

=item *

B<PENDING_WITHDRAWING> E<mdash> YouE<rsquo>ve submitted a request to
withdraw an address range from being advertised but it is still being
advertised by AWS Global Accelerator.

=item *

B<PENDING_DEPROVISIONING> E<mdash> YouE<rsquo>ve submitted a request to
deprovision an address range from AWS Global Accelerator but it is
still provisioned.

=item *

B<DEPROVISIONED> E<mdash> The address range is deprovisioned from AWS
Global Accelerator.

=item *

B<FAILED_PROVISION > E<mdash> The request to provision the address
range from AWS Global Accelerator was not successful. Please make sure
that you provide all of the correct information, and try again. If the
request fails a second time, contact AWS support.

=item *

B<FAILED_ADVERTISING> E<mdash> The request for AWS Global Accelerator
to advertise the address range was not successful. Please make sure
that you provide all of the correct information, and try again. If the
request fails a second time, contact AWS support.

=item *

B<FAILED_WITHDRAW> E<mdash> The request to withdraw the address range
from advertising by AWS Global Accelerator was not successful. Please
make sure that you provide all of the correct information, and try
again. If the request fails a second time, contact AWS support.

=item *

B<FAILED_DEPROVISION > E<mdash> The request to deprovision the address
range from AWS Global Accelerator was not successful. Please make sure
that you provide all of the correct information, and try again. If the
request fails a second time, contact AWS support.

=back


=head1 ATTRIBUTES


=head2 Cidr => Str

The address range, in CIDR notation.


=head2 Events => ArrayRef[L<Paws::GlobalAccelerator::ByoipCidrEvent>]

A history of status changes for an IP address range that you bring to
AWS Global Accelerator through bring your own IP address (BYOIP).


=head2 State => Str

The state of the address pool.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GlobalAccelerator>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

