# Generated by default/object.tt
package Paws::GreengrassV2::DisassociateClientDeviceFromCoreDeviceErrorEntry;
  use Moose;
  has Code => (is => 'ro', isa => 'Str', request_name => 'code', traits => ['NameInRequest']);
  has Message => (is => 'ro', isa => 'Str', request_name => 'message', traits => ['NameInRequest']);
  has ThingName => (is => 'ro', isa => 'Str', request_name => 'thingName', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::GreengrassV2::DisassociateClientDeviceFromCoreDeviceErrorEntry

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GreengrassV2::DisassociateClientDeviceFromCoreDeviceErrorEntry object:

  $service_obj->Method(Att1 => { Code => $value, ..., ThingName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GreengrassV2::DisassociateClientDeviceFromCoreDeviceErrorEntry object:

  $result = $service_obj->Method(...);
  $result->Att1->Code

=head1 DESCRIPTION

Contains an error that occurs from a request to disassociate a client
device from a core device. The
BatchDisassociateClientDeviceWithCoreDevice
(https://docs.aws.amazon.com/greengrass/v2/APIReference/API_BatchDisassociateClientDeviceWithCoreDevice.html)
operation returns a list of these errors.

=head1 ATTRIBUTES


=head2 Code => Str

The error code for the request.


=head2 Message => Str

A message that provides additional information about the error.


=head2 ThingName => Str

The name of the AWS IoT thing whose disassociate request failed.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GreengrassV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

